/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.function.Function;
import org.hswebframework.ezorm.rdb.metadata.CustomDataType;
import org.hswebframework.ezorm.rdb.metadata.DataTypeBuilderSupport;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;

public interface DataType {
    public String getId();

    public String getName();

    public SQLType getSqlType();

    public Class getJavaType();

    public static DataType custom(String id, String name, SQLType sqlType, Class javaType) {
        return CustomDataType.of(id, name, sqlType, javaType);
    }

    public static DataType jdbc(JDBCType jdbcType, Class javaType) {
        return JdbcDataType.of(jdbcType, javaType);
    }

    public static DataType builder(DataType type, Function<RDBColumnMetadata, String> builder) {
        return DataTypeBuilderSupport.of(type, builder);
    }
}

