/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import java.util.regex.Matcher;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.AbstractJdbcSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.H2Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.MSSQLDialect;
import org.hswebframework.ezorm.rdb.render.dialect.MysqlDialect;
import org.hswebframework.ezorm.rdb.render.dialect.OracleDialect;
import org.hswebframework.ezorm.rdb.render.dialect.PGSqlDialect;
import org.hswebframework.ezorm.rdb.render.dialect.function.SqlFunction;
import org.hswebframework.utils.StringUtils;

public interface Dialect {
    public static final Dialect MYSQL = new MysqlDialect();
    public static final Dialect ORACLE = new OracleDialect();
    public static final Dialect H2 = new H2Dialect();
    public static final Dialect MSSQL = new MSSQLDialect();
    public static final Dialect POSTGRES = new PGSqlDialect();

    public void setTermTypeMapper(String var1, TermTypeMapper var2);

    public boolean isSupportTermType(String var1);

    public void setDataTypeMapper(JDBCType var1, DataTypeMapper var2);

    public String getQuoteStart();

    public String getQuoteEnd();

    default public String quote(String keyword) {
        return this.getQuoteStart().concat(keyword).concat(this.getQuoteEnd());
    }

    public SqlAppender buildCondition(String var1, Term var2, RDBColumnMetaData var3, String var4);

    public String buildDataType(RDBColumnMetaData var1);

    public String doPaging(String var1, int var2, int var3);

    public String doPaging(String var1, int var2, int var3, boolean var4);

    public SqlFunction getFunction(String var1);

    public SqlFunction installFunction(String var1, SqlFunction var2);

    public boolean columnToUpperCase();

    default public String buildColumnName(String tableName, String columnName) {
        if (columnName.contains(".")) {
            return columnName;
        }
        if (StringUtils.isNullOrEmpty((Object)tableName)) {
            return StringUtils.concat((Object[])new Object[]{this.getQuoteStart(), this.columnToUpperCase() ? columnName.toUpperCase() : columnName, this.getQuoteEnd()});
        }
        return StringUtils.concat((Object[])new Object[]{tableName, ".", this.getQuoteStart(), this.columnToUpperCase() ? columnName.toUpperCase() : columnName, this.getQuoteEnd()});
    }

    public TableMetaParser getDefaultParser(SqlExecutor var1);

    public JDBCType getJdbcType(String var1);

    public static interface ColumnMapper {
        public String getColumn(RDBColumnMetaData var1);
    }

    public static interface DataTypeMapper {
        public String getDataType(RDBColumnMetaData var1);
    }

    public static interface TermTypeMapper {
        public SqlAppender accept(String var1, Term var2, RDBColumnMetaData var3, String var4);

        public static TermTypeMapper sql(String sql) {
            return (wherePrefix, term, column, tableAlias) -> new SqlAppender(sql);
        }

        public static TermTypeMapper sql(String sql, Object param) {
            return (wherePrefix, term, column, tableAlias) -> {
                String group;
                Object[] array;
                Object finalParam = param;
                String template = sql;
                if (template.contains("?")) {
                    int index = 0;
                    while (template.contains("?")) {
                        template = template.replaceFirst("\\?", "#\\{[" + index++ + "]}");
                    }
                } else if (finalParam instanceof Object[] && (array = (Object[])finalParam).length == 1) {
                    finalParam = array[0];
                }
                Matcher prepared_matcher = AbstractJdbcSqlExecutor.PREPARED_PATTERN.matcher(template);
                Matcher append_matcher = AbstractJdbcSqlExecutor.APPEND_PATTERN.matcher(template);
                term.setValue(finalParam);
                while (append_matcher.find()) {
                    group = append_matcher.group();
                    String reg = StringUtils.concat((Object[])new Object[]{"\\$\\{", group.replace("$", "\\$").replace("[", "\\[").replace("]", "\\]"), "}"});
                    String target = StringUtils.concat((Object[])new Object[]{"\\$\\{", wherePrefix, group.startsWith("[") ? ".value" : ".value.", group, "}"});
                    template = template.replaceFirst(reg, target);
                }
                while (prepared_matcher.find()) {
                    group = prepared_matcher.group();
                    template = template.replaceFirst(StringUtils.concat((Object[])new Object[]{"#\\{", group.replace("$", "\\$").replace("[", "\\[").replace("]", "\\]"), "}"}), StringUtils.concat((Object[])new Object[]{"#\\{", wherePrefix, group.startsWith("[") ? ".value" : ".value.", group, "}"}));
                }
                return new SqlAppender(template);
            };
        }
    }
}

