/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.parser;

import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.parser.AbstractTableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.MSSQLDialect;

public class SqlServer2012TableMetaParser
extends AbstractTableMetaParser {
    static String TABLE_META_SQL = "SELECT \nc.name as name,\nt.name as data_type,\nc.length as data_length,\nc.xscale as data_scale,\nc.xprec as data_precision,\ncase when c.isnullable=1 then 0 else  1 end as [not-null],\ncast(p.value as varchar(500)) as comment\nFROM syscolumns c\ninner join  systypes t on c.xusertype = t.xusertype \nleft join sys.extended_properties p on c.id=p.major_id and c.colid=p.minor_id\nWHERE c.id = object_id(#{table})";

    public SqlServer2012TableMetaParser(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
    }

    @Override
    Dialect getDialect() {
        return MSSQLDialect.MSSQL;
    }

    @Override
    String getTableMetaSql(String tname) {
        return TABLE_META_SQL;
    }

    @Override
    String getTableCommentSql(String tname) {
        return "select cast(p.value as varchar(500)) as comment from sys.extended_properties p  where p.major_id=object_id(#{table}) and p.minor_id=0";
    }

    @Override
    String getAllTableSql() {
        return "select name from sysobjects where xtype='U'";
    }

    @Override
    String getTableExistsSql() {
        return "select count(1) as total from sysobjects where xtype='U' and name = #{table}";
    }
}

