/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetaData;
import org.hswebframework.ezorm.core.meta.AbstractTableMetaData;
import org.hswebframework.ezorm.core.meta.TableMetaData;
import org.hswebframework.ezorm.rdb.meta.Correlation;
import org.hswebframework.ezorm.rdb.meta.IndexMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;

public class RDBTableMetaData
extends AbstractTableMetaData<RDBColumnMetaData>
implements TableMetaData,
Serializable,
Cloneable {
    private Set<Correlation> correlations = new LinkedHashSet<Correlation>();
    private List<IndexMetaData> indexes = new ArrayList<IndexMetaData>();
    private RDBDatabaseMetaData databaseMetaData;

    public RDBDatabaseMetaData getDatabaseMetaData() {
        return this.databaseMetaData;
    }

    public void setDatabaseMetaData(RDBDatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    public RDBColumnMetaData findColumn(String name) {
        RDBColumnMetaData metaData;
        if (name == null) {
            return null;
        }
        if (name.contains(".")) {
            RDBColumnMetaData column;
            Correlation correlation;
            String[] tmp = name.split("[.]");
            RDBTableMetaData metaData2 = this.databaseMetaData.getTableMetaData(tmp[0]);
            if (metaData2 == null && (correlation = this.getCorrelation(tmp[0])) != null) {
                metaData2 = this.databaseMetaData.getTableMetaData(correlation.getTargetTable());
            }
            if (metaData2 != null && null != (column = metaData2.findColumn(tmp[1]))) {
                return column;
            }
        }
        if ((metaData = (RDBColumnMetaData)this.columnMetaDataMap.get(name)) == null) {
            metaData = (RDBColumnMetaData)this.aliasColumnMetaDataMap.get(name);
        }
        return metaData;
    }

    public boolean renameColumn(String old, String newName) {
        RDBColumnMetaData oldField = (RDBColumnMetaData)this.columnMetaDataMap.get(old);
        if (oldField != null) {
            this.columnMetaDataMap.remove(old);
            this.columnMetaDataMap.put(newName, oldField);
            oldField.setName(newName);
            return true;
        }
        return false;
    }

    public RDBColumnMetaData getColumn(String name) {
        RDBColumnMetaData metaData = (RDBColumnMetaData)this.columnMetaDataMap.get(name);
        if (metaData == null) {
            metaData = (RDBColumnMetaData)this.aliasColumnMetaDataMap.get(name);
        }
        return metaData;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean columnInIndex(String column) {
        RDBColumnMetaData columnMeta = this.getColumn(column);
        if (columnMeta == null) {
            return false;
        }
        return this.indexes.stream().anyMatch(index -> index.contains(columnMeta.getName()));
    }

    public Correlation getCorrelation(String target) {
        for (Correlation correlation : this.correlations) {
            if (!correlation.getAlias().equals(target)) continue;
            return correlation;
        }
        for (Correlation correlation : this.correlations) {
            if (!correlation.getTargetTable().equals(target)) continue;
            return correlation;
        }
        return null;
    }

    public Correlation addCorrelation(Correlation correlation) {
        correlation.setIndex(this.correlations.size());
        this.correlations.add(correlation);
        return correlation;
    }

    public Set<Correlation> getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Set<Correlation> correlations) {
        this.correlations = correlations;
    }

    public RDBTableMetaData addColumn(RDBColumnMetaData columnMetaData) {
        return (RDBTableMetaData)super.addColumn((AbstractColumnMetaData)columnMetaData);
    }

    public Set<RDBColumnMetaData> getColumns() {
        return super.getColumns();
    }

    public RDBTableMetaData clone() {
        RDBTableMetaData metaData = new RDBTableMetaData();
        metaData.setName(this.name);
        metaData.setAlias(this.alias);
        metaData.setComment(this.comment);
        metaData.setValidator(this.validator);
        metaData.setProperties(this.properties);
        metaData.triggerBase = this.triggerBase;
        this.correlations.forEach(correlation -> metaData.addCorrelation(correlation.clone()));
        this.columnMetaDataMap.values().forEach(column -> metaData.addColumn(column.clone()));
        return metaData;
    }

    public String toString() {
        return this.name + " [" + this.alias + "](" + this.comment + ")";
    }

    public List<IndexMetaData> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<IndexMetaData> indexes) {
        this.indexes = indexes;
    }
}

