/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.Correlation;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.CommonSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleWhereSqlBuilder;
import org.hswebframework.utils.StringUtils;

public class SimpleSelectSqlRender
extends CommonSqlRender<QueryParam> {
    private Dialect dialect;

    public SimpleSelectSqlRender(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public SQL render(RDBTableMetaData metaData, QueryParam param) {
        return new SimpleSelectSqlRenderProcess(metaData, param).process();
    }

    class SimpleSelectSqlRenderProcess
    extends SimpleWhereSqlBuilder {
        private RDBTableMetaData metaData;
        private QueryParam param;
        private List<CommonSqlRender.OperationColumn> selectField;
        private SqlAppender whereSql = new SqlAppender();
        private Set<String> needSelectTable = new LinkedHashSet<String>();
        private List<Sort> sorts = new ArrayList<Sort>();

        public SimpleSelectSqlRenderProcess(RDBTableMetaData metaData, QueryParam param) {
            this.metaData = metaData;
            this.param = param;
            if (param.getIncludes().isEmpty() && param.getExcludes().isEmpty()) {
                param.includes(new String[]{"*"});
                metaData.getCorrelations().forEach(correlation -> param.includes(new String[]{correlation.getAlias() + ".*"}));
            }
            this.selectField = SimpleSelectSqlRender.this.parseOperationField(metaData, param);
            this.buildWhere(metaData, "", param.getTerms(), this.whereSql, this.needSelectTable);
            if (!this.whereSql.isEmpty()) {
                this.whereSql.removeFirst();
            }
            this.selectField.forEach(field -> this.needSelectTable.add(field.getTableName()));
            param.getSorts().forEach(sort -> {
                RDBColumnMetaData rDBColumnMetaData = metaData.findColumn(sort.getName());
                if (rDBColumnMetaData == null || rDBColumnMetaData.getName() == null) {
                    return;
                }
                String tableName = this.getTableAlias(metaData, sort.getName());
                this.needSelectTable.add(tableName);
                sort.setName(this.getDialect().buildColumnName(tableName, rDBColumnMetaData.getName()));
                this.sorts.add((Sort)sort);
            });
        }

        public SQL process() {
            SqlAppender appender = new SqlAppender();
            appender.add("SELECT ");
            if (this.selectField.isEmpty()) {
                appender.add(" * ");
            }
            this.selectField.forEach(operationColumn -> {
                RDBColumnMetaData rDBColumnMetaData = operationColumn.getRDBColumnMetaData();
                String tableName = rDBColumnMetaData.getTableMetaData().getName();
                Correlation correlation = this.metaData.getCorrelation(tableName);
                if (correlation == null) {
                    String tname = operationColumn.getTableName();
                    if (StringUtils.isNullOrEmpty((Object)tname)) {
                        tname = tableName;
                    }
                    String column = this.getDialect().buildColumnName(tname, rDBColumnMetaData.getName());
                    appender.add(column, " AS ", SimpleSelectSqlRender.this.dialect.getQuoteStart(), rDBColumnMetaData.getAlias(), SimpleSelectSqlRender.this.dialect.getQuoteEnd());
                } else if (correlation.isOne2one()) {
                    appender.add(this.getDialect().buildColumnName(operationColumn.getTableName(), rDBColumnMetaData.getName()), " AS ", SimpleSelectSqlRender.this.dialect.getQuoteStart(), operationColumn.getTableName(), ".", rDBColumnMetaData.getAlias(), SimpleSelectSqlRender.this.dialect.getQuoteEnd());
                }
                appender.add(",");
            });
            appender.removeLast();
            appender.add(" FROM ", this.metaData.getFullName(), " ", this.metaData.getAlias());
            this.needSelectTable.stream().filter(table -> !table.equals(this.metaData.getName()) && this.metaData.getCorrelation((String)table) != null).map(table -> this.metaData.getCorrelation((String)table)).sorted().forEach(correlation -> {
                appender.addSpc(new Object[]{"", correlation.getJoin(), correlation.getTargetTable(), correlation.getAlias(), "ON"});
                SqlAppender joinOn = new SqlAppender();
                this.buildWhere(this.metaData.getDatabaseMetaData().getTableMetaData(correlation.getTargetTable()), "", correlation.getTerms(), joinOn, new HashSet<String>());
                if (!joinOn.isEmpty()) {
                    joinOn.removeFirst();
                }
                appender.addAll(joinOn);
            });
            if (!this.whereSql.isEmpty()) {
                appender.add(" WHERE ", "").addAll(this.whereSql);
            }
            if (!this.sorts.isEmpty()) {
                appender.add(" ORDER BY ");
                this.sorts.forEach(sort -> appender.add(sort.getName(), " ", sort.getOrder(), ","));
                appender.removeLast();
            }
            String sql = appender.toString();
            if (this.param.isPaging() && !this.param.isForUpdate()) {
                sql = SimpleSelectSqlRender.this.dialect.doPaging(sql, this.param.getPageIndex(), this.param.getPageSize());
            }
            if (this.param.isForUpdate()) {
                sql = sql.concat(" FOR UPDATE");
            }
            return new SimpleSQL(sql, this.param);
        }

        @Override
        public Dialect getDialect() {
            return SimpleSelectSqlRender.this.dialect;
        }
    }
}

