/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.BindSQL;
import org.hswebframework.ezorm.rdb.executor.EmptySQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;

public abstract class AbstractMetaAlterRender
implements SqlRender<Boolean> {
    protected RDBDatabaseMetaData databaseMetaData;

    public AbstractMetaAlterRender(RDBDatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    @Override
    public SQL render(RDBTableMetaData metaData, Boolean executeRemove) {
        RDBTableMetaData old = this.databaseMetaData.getTableMetaData(metaData.getName());
        if (old == null) {
            throw new UnsupportedOperationException("\u65e7\u8868\u4e0d\u5b58\u5728!");
        }
        ArrayList changedField = new ArrayList();
        ArrayList addedField = new ArrayList();
        ArrayList deletedField = new ArrayList();
        RDBTableMetaData oldMeta = old;
        if (executeRemove.booleanValue()) {
            oldMeta.getColumns().forEach(oldField -> {
                RDBColumnMetaData newMeta = metaData.findColumn(oldField.getName());
                if (newMeta == null) {
                    newMeta = metaData.getColumns().stream().filter(fieldMetaData -> oldField.getName().equals(fieldMetaData.getProperty("old-name").getValue())).findFirst().orElse(null);
                }
                if (newMeta == null || !newMeta.getName().equals(oldField.getName())) {
                    deletedField.add(oldField);
                }
            });
        }
        metaData.getColumns().forEach(newField -> {
            RDBColumnMetaData oldField;
            String oldName = (String)newField.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = newField.getName();
            }
            if ((oldField = oldMeta.findColumn(oldName)) == null) {
                addedField.add(newField);
            } else if (!newField.getName().equals(oldField.getName()) || newField.getJdbcType() == oldField.getJdbcType() && !newField.getDataType().equals(oldField.getDataType())) {
                changedField.add(newField);
            }
        });
        if (addedField.isEmpty() && changedField.isEmpty() && deletedField.isEmpty()) {
            return new EmptySQL();
        }
        List addSql = addedField.stream().map(this::buildAdd).flatMap(Collection::stream).collect(Collectors.toList());
        List changedSql = changedField.stream().map(this::buildAlter).flatMap(Collection::stream).collect(Collectors.toList());
        List deleteSql = deletedField.stream().map(this::buildDrop).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<SqlAppender> all = new ArrayList<SqlAppender>();
        all.addAll(addSql);
        all.addAll(changedSql);
        all.addAll(deleteSql);
        LinkedList sqlList = new LinkedList(this.merge(all).stream().map(SqlAppender::toString).map(SimpleSQL::new).collect(Collectors.toList()));
        if (sqlList.isEmpty()) {
            return new EmptySQL();
        }
        SimpleSQL mainSql = (SimpleSQL)sqlList.get(0);
        sqlList.removeFirst();
        mainSql.setBindSQLs(sqlList.stream().map(BindSQL::new).collect(Collectors.toList()));
        return mainSql;
    }

    protected List<SqlAppender> merge(List<SqlAppender> sql) {
        return sql;
    }

    protected List<SqlAppender> buildAdd(RDBColumnMetaData column) {
        SqlAppender append = new SqlAppender();
        append.add("alter table ", column.getTableMetaData().getFullName(), " add ", column.getName(), " ");
        if (column.getColumnDefinition() != null) {
            append.add(column.getColumnDefinition());
        } else {
            append.add(column.getDataType());
            if (column.isNotNull() || column.isPrimaryKey()) {
                append.add(" not null");
            }
            if (column.getComment() != null) {
                append.add(" comment '", column.getComment(), "'");
            }
        }
        return new ArrayList<SqlAppender>(Collections.singletonList(append));
    }

    protected List<SqlAppender> buildAlter(RDBColumnMetaData column) {
        SqlAppender append = new SqlAppender();
        append.add("alter table ", column.getTableMetaData().getFullName(), " modify ", column.getName(), " ");
        if (column.getColumnDefinition() != null) {
            append.add(column.getColumnDefinition());
        } else {
            append.add(column.getDataType());
            if (column.isNotNull() || column.isPrimaryKey()) {
                append.add(" not null");
            }
            if (column.getComment() != null) {
                append.add(" comment '", column.getComment(), "'");
            }
        }
        return new ArrayList<SqlAppender>(Collections.singletonList(append));
    }

    protected List<SqlAppender> buildDrop(RDBColumnMetaData column) {
        String dropSql = String.format("alter table %s drop column %s", column.getTableMetaData().getFullName(), column.getName());
        return new ArrayList<SqlAppender>(Collections.singletonList(new SqlAppender(dropSql)));
    }
}

