/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.parser;

import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.expand.SimpleMapWrapper;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.utils.StringUtils;

public abstract class AbstractTableMetaParser
implements TableMetaParser {
    protected static Map<JDBCType, Class> defaultJavaTypeMap = new HashMap<JDBCType, Class>();
    protected Map<JDBCType, Class> javaTypeMap = new HashMap<JDBCType, Class>();
    protected String databaseName;
    protected SqlExecutor sqlExecutor;

    public String getDatabaseName() {
        return this.databaseName;
    }

    abstract Dialect getDialect();

    public AbstractTableMetaParser(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    abstract String getTableMetaSql(String var1);

    abstract String getTableCommentSql(String var1);

    abstract String getAllTableSql();

    abstract String getTableExistsSql();

    @Override
    public boolean tableExists(String name) {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("table", name);
            Map<String, Object> res = this.sqlExecutor.single(new SimpleSQL(this.getTableExistsSql(), param), new LowerCasePropertySimpleMapWrapper());
            return res.get("total") != null && StringUtils.toInt((Object)res.get("total")) > 0;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RDBTableMetaData parse(String name) {
        if (!this.tableExists(name)) {
            return null;
        }
        RDBTableMetaData metaData = new RDBTableMetaData();
        metaData.setName(name);
        metaData.setAlias(name);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        List<RDBColumnMetaData> metaDatas = this.sqlExecutor.list(new SimpleSQL(this.getTableMetaSql(name), param), new RDBColumnMetaDataWrapper());
        metaDatas.forEach(metaData::addColumn);
        Map<String, Object> comment = this.sqlExecutor.single(new SimpleSQL(this.getTableCommentSql(name), param), new LowerCasePropertySimpleMapWrapper());
        if (null != comment && comment.get("comment") != null) {
            metaData.setComment(String.valueOf(comment.get("comment")));
        }
        return metaData;
    }

    @Override
    public List<RDBTableMetaData> parseAll() throws SQLException {
        List<Map<String, Object>> tables = this.sqlExecutor.list(new SimpleSQL(this.getAllTableSql()), new LowerCasePropertySimpleMapWrapper());
        return tables.stream().map(map -> (String)map.get("name")).filter(Objects::nonNull).map(this::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    static {
        defaultJavaTypeMap.put(JDBCType.VARCHAR, String.class);
        defaultJavaTypeMap.put(JDBCType.CLOB, String.class);
        defaultJavaTypeMap.put(JDBCType.BLOB, byte[].class);
        defaultJavaTypeMap.put(JDBCType.DATE, Date.class);
        defaultJavaTypeMap.put(JDBCType.TIME, Date.class);
        defaultJavaTypeMap.put(JDBCType.TIMESTAMP, Date.class);
        defaultJavaTypeMap.put(JDBCType.BIT, Byte.class);
        defaultJavaTypeMap.put(JDBCType.BIGINT, Long.class);
        defaultJavaTypeMap.put(JDBCType.NUMERIC, Double.class);
        defaultJavaTypeMap.put(JDBCType.INTEGER, Integer.class);
        defaultJavaTypeMap.put(JDBCType.DOUBLE, Double.class);
        defaultJavaTypeMap.put(JDBCType.FLOAT, Float.class);
        defaultJavaTypeMap.put(JDBCType.CHAR, String.class);
        defaultJavaTypeMap.put(JDBCType.TINYINT, Byte.class);
    }

    class RDBColumnMetaDataWrapper
    implements ObjectWrapper<RDBColumnMetaData> {
        RDBColumnMetaDataWrapper() {
        }

        public Class<RDBColumnMetaData> getType() {
            return RDBColumnMetaData.class;
        }

        public RDBColumnMetaData newInstance() {
            return new RDBColumnMetaData();
        }

        public void wrapper(RDBColumnMetaData instance, int index, String attr, Object value) {
            String stringValue;
            if (value instanceof String) {
                stringValue = ((String)value).toLowerCase();
            } else {
                String string = stringValue = value == null ? "" : value.toString();
            }
            if (attr.equalsIgnoreCase("name")) {
                instance.setName(stringValue);
                instance.setProperty("old-name", stringValue);
            } else if (attr.equalsIgnoreCase("comment")) {
                instance.setComment(stringValue);
            } else {
                if (attr.toLowerCase().equals("not-null")) {
                    value = "1".equals(stringValue);
                    instance.setNotNull((Boolean)value);
                }
                instance.setProperty(attr.toLowerCase(), value);
            }
        }

        public boolean done(RDBColumnMetaData instance) {
            String data_type = instance.getProperty("data_type").toString().toLowerCase();
            int len = instance.getProperty("data_length").toInt();
            int data_precision = instance.getProperty("data_precision").toInt();
            int data_scale = instance.getProperty("data_scale").toInt();
            instance.setLength(len);
            instance.setPrecision(data_precision);
            instance.setScale(data_scale);
            JDBCType jdbcType = AbstractTableMetaParser.this.getDialect().getJdbcType(data_type);
            Class javaType = Optional.ofNullable(AbstractTableMetaParser.this.javaTypeMap.get(jdbcType)).orElseGet(() -> defaultJavaTypeMap.getOrDefault(jdbcType, String.class));
            instance.setJdbcType(jdbcType);
            instance.setJavaType(javaType);
            instance.setDataType(AbstractTableMetaParser.this.getDialect().buildDataType(instance));
            return true;
        }
    }

    class LowerCasePropertySimpleMapWrapper
    extends SimpleMapWrapper {
        LowerCasePropertySimpleMapWrapper() {
        }

        @Override
        public void wrapper(Map<String, Object> instance, int index, String attr, Object value) {
            attr = attr.toLowerCase();
            super.wrapper(instance, index, attr, value);
        }
    }
}

