/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple.wrapper;

import java.util.HashMap;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.RDBTable;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;

public class TriggerWrapper<T>
implements ObjectWrapper<T> {
    private ObjectWrapper<T> defaultWrapper;
    private RDBTable table;
    private RDBDatabase database;
    private RDBTableMetaData metaData;

    public TriggerWrapper(RDBDatabase database, RDBTable table, ObjectWrapper<T> defaultWrapper) {
        this.defaultWrapper = defaultWrapper;
        this.database = database;
        this.table = table;
        this.metaData = table.getMeta();
    }

    public Class<T> getType() {
        return this.defaultWrapper.getType();
    }

    public T newInstance() {
        return (T)this.defaultWrapper.newInstance();
    }

    public void wrapper(T instance, int index, String attr, Object value) {
        if (this.metaData.triggerIsSupport("select.wrapper.each")) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("table", this.table);
            context.put("database", this.database);
            context.put("index", index);
            context.put("property", attr);
            context.put("value", value);
            context.put("instance", instance);
            this.metaData.on("select.wrapper.each", context);
        }
        this.defaultWrapper.wrapper(instance, index, attr, value);
    }

    public boolean done(T instance) {
        if (this.metaData.triggerIsSupport("select.wrapper.done")) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("table", this.table);
            context.put("database", this.database);
            context.put("instance", instance);
            this.metaData.on("select.wrapper.done", context);
        }
        return this.defaultWrapper.done(instance);
    }
}

