/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.hswebframework.ezorm.core.Insert;
import org.hswebframework.ezorm.core.Validator;
import org.hswebframework.ezorm.core.param.InsertParam;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.simple.SimpleTable;
import org.hswebframework.ezorm.rdb.simple.ValidatorAndTriggerSupport;

class SimpleInsert<T>
extends ValidatorAndTriggerSupport<Insert<T>>
implements Insert<T> {
    private InsertParam insertParam;
    private SimpleTable<T> table;
    private SqlExecutor sqlExecutor;

    public SimpleInsert(SimpleTable<T> table, SqlExecutor sqlExecutor) {
        this.table = table;
        this.sqlExecutor = sqlExecutor;
        this.insertParam = new InsertParam();
    }

    protected Insert<T> addSqlTerm(SqlTerm term) {
        return this;
    }

    public Insert<T> value(T data) {
        this.insertParam.setData(data);
        return this;
    }

    public Insert<T> values(Collection<T> data) {
        this.insertParam.setData(data);
        return this;
    }

    public int exec() throws SQLException {
        boolean supportBefore = !this.triggerSkip && this.table.getMeta().triggerIsSupport("insert.before");
        boolean supportDone = !this.triggerSkip && this.table.getMeta().triggerIsSupport("insert.done");
        Map<String, Object> context = null;
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", this.insertParam);
        }
        if (supportBefore) {
            this.table.getMeta().on("insert.before", context);
        }
        SqlRender render = this.table.getMeta().getDatabaseMetaData().getRenderer(SqlRender.TYPE.INSERT);
        SQL sql = render.render(this.table.getMeta(), this.insertParam);
        this.tryValidate(this.insertParam.getData(), Validator.Operation.INSERT);
        int total = this.sqlExecutor.insert(sql);
        if (supportDone) {
            context.put("total", total);
            this.table.getMeta().on("insert.done", context);
        }
        return total;
    }

    @Override
    RDBTableMetaData getTableMeta() {
        return this.table.getMeta();
    }
}

