/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple;

import java.sql.SQLException;
import java.util.Map;
import org.hswebframework.ezorm.core.Delete;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.simple.SimpleTable;
import org.hswebframework.ezorm.rdb.simple.ValidatorAndTriggerSupport;

class SimpleDelete
extends ValidatorAndTriggerSupport<Delete>
implements Delete {
    private Param param;
    private SimpleTable table;
    private SqlExecutor sqlExecutor;
    private RDBTableMetaData tableMetaData;
    private TermTypeConditionalSupport.Accepter<Delete, Object> accepter = this::and;

    public SimpleDelete(SimpleTable table, SqlExecutor sqlExecutor) {
        this.table = table;
        this.sqlExecutor = sqlExecutor;
        this.param = new Param();
        this.tableMetaData = table.getMeta();
    }

    protected Delete addSqlTerm(SqlTerm term) {
        this.param.addTerm((Term)term);
        return this;
    }

    public Delete and(String condition, String termType, Object value) {
        this.param.and(condition, termType, value);
        return this;
    }

    public Delete or(String condition, String termType, Object value) {
        this.param.or(condition, termType, value);
        return this;
    }

    public Delete and() {
        this.setAnd();
        this.accepter = this::and;
        return this;
    }

    public Delete or() {
        this.setOr();
        this.accepter = this::or;
        return this;
    }

    public TermTypeConditionalSupport.Accepter<Delete, Object> getAccepter() {
        return this.accepter;
    }

    public NestConditional<Delete> nest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.param.nest());
    }

    public NestConditional<Delete> nest(String column, Object value) {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.param.nest(column, value));
    }

    public NestConditional<Delete> orNest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.param.orNest());
    }

    public NestConditional<Delete> orNest(String column, Object value) {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.param.orNest(column, value));
    }

    public Delete setParam(Param param) {
        this.param = param;
        return this;
    }

    public int exec() throws SQLException {
        boolean supportDone;
        Map<String, Object> context = null;
        boolean supportBefore = !this.triggerSkip && this.tableMetaData.triggerIsSupport("delete.before");
        boolean bl = supportDone = !this.triggerSkip && this.tableMetaData.triggerIsSupport("delete.done");
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", this.param);
        }
        if (supportBefore) {
            this.tableMetaData.on("delete.before", context);
        }
        SqlRender render = this.tableMetaData.getDatabaseMetaData().getRenderer(SqlRender.TYPE.DELETE);
        SQL sql = render.render(this.table.getMeta(), this.param);
        int size = this.sqlExecutor.delete(sql);
        if (supportDone) {
            context.put("total", size);
            this.tableMetaData.on("delete.done", context);
        }
        return size;
    }

    @Override
    RDBTableMetaData getTableMeta() {
        return this.tableMetaData;
    }

    public Delete accept(Term term) {
        this.param.addTerm(term);
        return this;
    }
}

