/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.core.ObjectWrapperFactory;
import org.hswebframework.ezorm.core.meta.TableMetaData;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.RDBTable;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.builder.TableBuilder;
import org.hswebframework.ezorm.rdb.meta.builder.simple.SimpleTableBuilder;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.simple.SimpleTable;
import org.hswebframework.ezorm.rdb.simple.wrapper.AdvancedMapWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDatabase
implements RDBDatabase {
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private RDBDatabaseMetaData metaData;
    private SqlExecutor sqlExecutor;
    private boolean autoParse = false;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, RDBTable> cache = new HashMap<String, RDBTable>();

    public SimpleDatabase(RDBDatabaseMetaData metaData, SqlExecutor sqlExecutor) {
        this.metaData = metaData;
        this.sqlExecutor = sqlExecutor;
    }

    @Override
    public RDBDatabaseMetaData getMeta() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> RDBTable<T> getTable(String name) {
        SimpleTable table;
        RDBTableMetaData tableMetaData = this.metaData.getTableMetaData(name);
        if (tableMetaData == null) {
            if (this.metaData.getParser() != null && this.autoParse) {
                tableMetaData = this.metaData.getParser().parse(name);
            }
            if (tableMetaData != null) {
                this.metaData.putTable(tableMetaData);
            } else {
                throw new NullPointerException("\u8868\u4e0d\u5b58\u5728!");
            }
        }
        try {
            this.readWriteLock.readLock().lock();
            table = this.cache.get(name);
            if (null != table) {
                SimpleTable simpleTable = table;
                return simpleTable;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (table == null) {
            try {
                this.readWriteLock.writeLock().lock();
                Object wrapper = tableMetaData.getObjectWrapper();
                if (wrapper == null) {
                    ObjectWrapperFactory factory = this.metaData.getObjectWrapperFactory();
                    wrapper = factory != null ? factory.createObjectWrapper((TableMetaData)tableMetaData) : new AdvancedMapWrapper(tableMetaData);
                }
                table = new SimpleTable(tableMetaData, this, this.sqlExecutor, (ObjectWrapper)wrapper);
                this.cache.put(name, table);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        return table;
    }

    @Override
    public <T> RDBTable<T> createTable(RDBTableMetaData tableMetaData) throws SQLException {
        SqlRender render = this.metaData.getRenderer(SqlRender.TYPE.META_CREATE);
        SQL sql = render.render(tableMetaData, new Object());
        this.sqlExecutor.exec(sql);
        this.metaData.putTable(tableMetaData);
        return this.getTable(tableMetaData.getName());
    }

    @Override
    public <T> RDBTable<T> reloadTable(RDBTableMetaData tableMetaData) {
        try {
            this.readWriteLock.writeLock().lock();
            this.cache.remove(tableMetaData.getName());
            this.cache.remove(tableMetaData.getAlias());
            this.metaData.putTable(tableMetaData);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return this.getTable(tableMetaData.getAlias());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> RDBTable<T> alterTable(RDBTableMetaData tableMetaData) throws SQLException {
        SqlRender render = this.metaData.getRenderer(SqlRender.TYPE.META_ALTER);
        RDBTable<T> old = this.getTable(tableMetaData.getName());
        if (old == null) {
            throw new NullPointerException("\u65e7\u8868\u4e0d\u5b58\u5728!");
        }
        int total = old.createQuery().total();
        SQL sql = render.render(tableMetaData, total == 0);
        try {
            this.readWriteLock.writeLock().lock();
            this.sqlExecutor.exec(sql);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        this.reloadTable(tableMetaData);
        return this.getTable(tableMetaData.getName());
    }

    @Override
    public boolean removeTable(String name) {
        try {
            this.readWriteLock.writeLock().lock();
            this.metaData.removeTable(name);
            boolean bl = true;
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Map<String, Object> getTriggerContextRoot() {
        return new HashMap<String, Object>();
    }

    @Override
    public TableBuilder createOrAlter(String name) {
        RDBTableMetaData tableMetaData = new RDBTableMetaData();
        tableMetaData.setName(name);
        tableMetaData.setDatabaseMetaData(this.metaData);
        try {
            boolean tableExists = this.metaData.getParser() != null ? this.metaData.getParser().tableExists(name) : this.sqlExecutor.tableExists(name);
            if (tableExists) {
                if (this.metaData.getParser() != null) {
                    RDBTableMetaData tmp = this.metaData.getParser().parse(name);
                    tmp.getColumns().forEach(tableMetaData::addColumn);
                } else {
                    this.logger.warn("table {} exists,but tableMetaParser is null", (Object)name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SimpleTableBuilder(tableMetaData, this, this.sqlExecutor);
    }

    public void setAutoParse(boolean autoParse) {
        this.autoParse = autoParse;
    }

    public boolean isAutoParse() {
        return this.autoParse;
    }
}

