/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.sqlserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.BindSQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.CommonCreateIndexRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.ezorm.rdb.render.support.sqlserver.CommentSupportRender;
import org.hswebframework.utils.StringUtils;

public class SqlServerMetaCreateRender
extends CommentSupportRender
implements SqlRender {
    @Override
    protected boolean isDropCommentBefore() {
        return false;
    }

    public SQL render(RDBTableMetaData table, Object param) {
        SqlAppender createBody = new SqlAppender();
        ArrayList<SQL> comments = new ArrayList<SQL>();
        Set<RDBColumnMetaData> RDBColumnMetaDatas = table.getColumns();
        if (RDBColumnMetaDatas.isEmpty()) {
            throw new UnsupportedOperationException("\u672a\u6307\u5b9a\u4efb\u4f55\u5b57\u6bb5");
        }
        createBody.add("\nCREATE TABLE ", table.getName(), "(");
        RDBColumnMetaDatas.forEach(column -> {
            createBody.add("\n\t[", column.getName(), "] ").add(column.getDataType());
            if (column.isNotNull() || column.isPrimaryKey()) {
                createBody.add(" NOT NULL ");
            }
            if (column.isPrimaryKey()) {
                createBody.add("PRIMARY KEY ");
            }
            if (!StringUtils.isNullOrEmpty((Object)column.getComment())) {
                comments.add(this.buildColumnCommentSql(table.getName(), column.getName().toUpperCase(), column.getComment()));
            }
            createBody.add(",");
        });
        comments.add(this.buildTableCommentSql(table.getName(), table.getComment()));
        createBody.removeLast();
        createBody.add("\n)");
        SimpleSQL simpleSQL = new SimpleSQL(createBody.toString(), param);
        List<BindSQL> bindSQLs = comments.stream().map(s -> {
            BindSQL sql = new BindSQL();
            sql.setSql((SQL)s);
            return sql;
        }).collect(Collectors.toList());
        for (SQL sql : CommonCreateIndexRender.buildCreateIndexSql(table)) {
            bindSQLs.add(new BindSQL(sql));
        }
        simpleSQL.setBindSQLs(bindSQLs);
        return simpleSQL;
    }
}

