/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.sqlserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.BindSQL;
import org.hswebframework.ezorm.rdb.executor.EmptySQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.ezorm.rdb.render.support.sqlserver.CommentSupportRender;
import org.hswebframework.utils.StringUtils;

public class SqlServerMetaAlterRender
extends CommentSupportRender
implements SqlRender<Boolean> {
    @Override
    public SQL render(RDBTableMetaData table, Boolean executeRemove) {
        RDBTableMetaData old = table.getDatabaseMetaData().getTableMetaData(table.getName());
        if (old == null) {
            throw new UnsupportedOperationException("\u65e7\u8868\u4e0d\u5b58\u5728!");
        }
        ArrayList changedField = new ArrayList();
        ArrayList addedField = new ArrayList();
        ArrayList deletedField = new ArrayList();
        RDBTableMetaData oldMeta = old;
        if (executeRemove.booleanValue()) {
            oldMeta.getColumns().forEach(oldField -> {
                RDBColumnMetaData newMeta = table.findColumn(oldField.getName());
                if (newMeta == null) {
                    newMeta = table.getColumns().stream().filter(columnMetaData -> oldField.getName().equals(columnMetaData.getProperty("old-name").getValue())).findFirst().orElse(null);
                }
                if (newMeta == null || !newMeta.getName().equals(oldField.getName())) {
                    deletedField.add(oldField);
                }
            });
        }
        table.getColumns().forEach(newField -> {
            RDBColumnMetaData oldField;
            String oldName = (String)newField.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = newField.getName();
            }
            if ((oldField = oldMeta.findColumn(oldName)) == null) {
                addedField.add(newField);
            } else if (!(newField.getName().equals(oldField.getName()) && newField.getDataType().equals(oldField.getDataType()) && newField.getComment().equals(oldField.getComment()) && oldField.isNotNull() == newField.isNotNull())) {
                changedField.add(newField);
            }
        });
        LinkedList<BindSQL> bind = new LinkedList<BindSQL>();
        ArrayList<SQL> comments = new ArrayList<SQL>();
        String newTableComment = table.getComment();
        String oldTableComment = old.getComment();
        if (newTableComment == null) {
            newTableComment = "";
        }
        if (oldTableComment == null) {
            oldTableComment = "";
        }
        if (!newTableComment.equals(oldTableComment)) {
            comments.add(this.buildTableCommentSql(table.getName(), table.getComment()));
        }
        if (addedField.isEmpty() && changedField.isEmpty() && deletedField.isEmpty() && comments.isEmpty()) {
            return new EmptySQL();
        }
        addedField.forEach(column -> {
            SqlAppender append = new SqlAppender();
            append.add("ALTER TABLE ", table.getName(), " ADD [", column.getName(), "] ", column.getDataType());
            if (column.isNotNull()) {
                append.add(" NOT NULL");
            }
            if (column.isPrimaryKey()) {
                append.add(" PRIMARY KEY ");
            }
            if (StringUtils.isNullOrEmpty((Object)column.getComment())) {
                comments.add(this.buildDropColumnCommentSql(table.getName(), column.getName(), column.getAlias()));
            } else {
                comments.add(this.buildColumnCommentSql(table.getName(), column.getName(), column.getComment()));
            }
            SimpleSQL simpleSQL = new SimpleSQL(append.toString(), column);
            BindSQL bindSQL = new BindSQL();
            bindSQL.setSql(simpleSQL);
            bindSQL.setToField(column.getName());
            bind.add(bindSQL);
        });
        changedField.forEach(column -> {
            BindSQL bindSQL;
            String oldName = (String)column.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = column.getName();
            }
            RDBColumnMetaData oldColumn = oldMeta.findColumn(oldName);
            if (!oldName.equals(column.getName())) {
                String sql = "EXEC sp_rename #{old}, #{name}, 'COLUMN'";
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("old", oldName);
                param.put("name", column.getName());
                bindSQL = new BindSQL();
                bindSQL.setSql(new SimpleSQL(sql, param));
                bind.add(bindSQL);
                table.renameColumn(oldName, column.getName());
            }
            if (!oldColumn.getDataType().equals(column.getDataType()) || oldColumn.isNotNull() != column.isNotNull()) {
                SqlAppender append = new SqlAppender();
                append.add("ALTER TABLE ", table.getName(), " ALTER COLUMN [", column.getName(), "] ", column.getDataType());
                if (oldColumn.isNotNull() != column.isNotNull()) {
                    if (column.isNotNull()) {
                        append.add(" NOT NULL");
                    } else {
                        append.add(" NULL");
                    }
                }
                SimpleSQL simpleSQL = new SimpleSQL(append.toString(), column);
                bindSQL = new BindSQL();
                bindSQL.setSql(simpleSQL);
                bindSQL.setToField(column.getName());
                bind.add(bindSQL);
            }
            String nc = column.getComment();
            String oc = oldColumn.getComment();
            if (nc == null) {
                nc = "";
            }
            if (oc == null) {
                oc = "";
            }
            if (nc.equals(oc)) {
                return;
            }
            if (StringUtils.isNullOrEmpty((Object)nc)) {
                comments.add(this.buildDropColumnCommentSql(table.getName(), column.getName(), column.getAlias()));
            } else {
                comments.add(this.buildColumnCommentSql(table.getName(), column.getName(), nc));
            }
        });
        deletedField.forEach(column -> {
            String dropSql = String.format("ALTER TABLE %s DROP COLUMN [%s]", table.getName(), column.getName());
            SimpleSQL simpleSQL = new SimpleSQL(dropSql, column);
            BindSQL bindSQL = new BindSQL();
            bindSQL.setSql(simpleSQL);
            bindSQL.setToField(column.getName());
            bind.add(bindSQL);
        });
        LinkedList commentSql = new LinkedList(comments.stream().map(s -> {
            BindSQL binSql = new BindSQL();
            binSql.setSql((SQL)s);
            return binSql;
        }).collect(Collectors.toList()));
        SQL sql = null;
        if (bind.isEmpty()) {
            return new EmptySQL();
        }
        bind.addAll(commentSql);
        if (!bind.isEmpty()) {
            sql = ((BindSQL)bind.get(0)).getSql();
            bind.removeFirst();
        }
        if (sql != null && !bind.isEmpty()) {
            ((SimpleSQL)sql).setBindSQLs(bind);
        }
        return sql;
    }

    @Override
    protected boolean isDropCommentBefore() {
        return true;
    }
}

