/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import java.util.List;
import java.util.StringJoiner;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.parser.SqlServer2012TableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.DefaultDialect;
import org.hswebframework.ezorm.rdb.render.dialect.term.BoostTermTypeMapper;
import org.hswebframework.utils.StringUtils;

public class MSSQLDialect
extends DefaultDialect {
    public MSSQLDialect() {
        this.defaultDataTypeMapper = meta -> meta.getJdbcType().getName().toLowerCase();
        this.setDataTypeMapper(JDBCType.CHAR, meta -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.NCHAR, meta -> StringUtils.concat((Object[])new Object[]{"nchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.VARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.NVARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"nvarchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.TIMESTAMP, meta -> "datetime");
        this.setDataTypeMapper(JDBCType.TIME, meta -> "time");
        this.setDataTypeMapper(JDBCType.DATE, meta -> "date");
        this.setDataTypeMapper(JDBCType.CLOB, meta -> "text");
        this.setDataTypeMapper(JDBCType.LONGVARBINARY, meta -> "varbinary(max)");
        this.setDataTypeMapper(JDBCType.LONGVARCHAR, meta -> "text");
        this.setDataTypeMapper(JDBCType.BLOB, meta -> "varbinary(max)");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.DOUBLE, meta -> "double");
        this.setDataTypeMapper(JDBCType.INTEGER, meta -> "int");
        this.setDataTypeMapper(JDBCType.NUMERIC, meta -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.DECIMAL, meta -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.TINYINT, meta -> "tinyint");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.OTHER, meta -> "other");
        this.setDataTypeMapper(JDBCType.REAL, meta -> "real");
        this.installFunction("concat", param -> {
            List<Object> listParam = BoostTermTypeMapper.convertList(param.getParam());
            StringJoiner joiner = new StringJoiner(",", "concat(", ")");
            listParam.stream().map(String::valueOf).forEach(joiner::add);
            return joiner.toString();
        });
        this.installFunction("bitand", param -> {
            List<Object> listParam = BoostTermTypeMapper.convertList(param.getParam());
            if (listParam.size() != 2) {
                throw new IllegalArgumentException("[bitand]\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u4e3a2");
            }
            StringJoiner joiner = new StringJoiner(",", "bitand(", ")");
            listParam.stream().map(String::valueOf).forEach(joiner::add);
            return joiner.toString();
        });
    }

    @Override
    public String getQuoteStart() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public String doPaging(String sql, int pageIndex, int pageSize, boolean prepare) {
        if (!sql.contains("order") && !sql.contains("ORDER")) {
            sql = sql.concat(" order by 1");
        }
        if (prepare) {
            return sql + " OFFSET #{pageSize}*#{pageIndex}  ROWS FETCH NEXT #{pageSize} ROWS ONLY";
        }
        return sql.concat(" OFFSET " + pageIndex * pageSize + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY");
    }

    @Override
    public boolean columnToUpperCase() {
        return false;
    }

    @Override
    public TableMetaParser getDefaultParser(SqlExecutor sqlExecutor) {
        return new SqlServer2012TableMetaParser(sqlExecutor);
    }
}

