/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.builder.simple;

import java.sql.SQLException;
import java.util.Set;
import java.util.function.Consumer;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.builder.ColumnBuilder;
import org.hswebframework.ezorm.rdb.meta.builder.IndexBuilder;
import org.hswebframework.ezorm.rdb.meta.builder.TableBuilder;
import org.hswebframework.ezorm.rdb.meta.builder.simple.SimpleColumnBuilder;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;

public class SimpleTableBuilder
implements TableBuilder {
    public RDBTableMetaData rdbTableMetaData;
    public RDBDatabase database;
    public SqlExecutor sqlExecutor;
    public TableMetaParser parser;

    public SimpleTableBuilder(RDBTableMetaData rdbTableMetaData, RDBDatabase database, SqlExecutor sqlExecutor) {
        this.rdbTableMetaData = rdbTableMetaData;
        this.database = database;
        this.sqlExecutor = sqlExecutor;
        this.parser = database.getMeta().getParser();
        if (this.parser == null) {
            this.parser = database.getMeta().getDialect().getDefaultParser(sqlExecutor);
        }
    }

    @Override
    public IndexBuilder index() {
        return new IndexBuilder(this, this.rdbTableMetaData);
    }

    @Override
    public TableBuilder custom(Consumer<RDBTableMetaData> consumer) {
        consumer.accept(this.rdbTableMetaData);
        return this;
    }

    @Override
    public TableBuilder addColumn(Set<RDBColumnMetaData> columns) {
        columns.forEach(this.rdbTableMetaData::addColumn);
        return this;
    }

    @Override
    public ColumnBuilder addOrAlterColumn(String name) {
        RDBColumnMetaData rdbColumnMetaData = this.rdbTableMetaData.getColumn(name);
        if (null == rdbColumnMetaData) {
            rdbColumnMetaData = new RDBColumnMetaData();
            rdbColumnMetaData.setName(name);
        }
        return new SimpleColumnBuilder(rdbColumnMetaData, this, this.rdbTableMetaData);
    }

    @Override
    public TableBuilder removeColumn(String name) {
        this.rdbTableMetaData.removeColumn(name);
        return this;
    }

    @Override
    public ColumnBuilder addColumn() {
        RDBColumnMetaData rdbColumnMetaData = new RDBColumnMetaData();
        SimpleColumnBuilder columnBuilder = new SimpleColumnBuilder(rdbColumnMetaData, this, this.rdbTableMetaData);
        return columnBuilder;
    }

    @Override
    public TableBuilder comment(String comment) {
        this.rdbTableMetaData.setComment(comment);
        return this;
    }

    @Override
    public TableBuilder property(String propertyName, Object value) {
        this.rdbTableMetaData.setProperty(propertyName, value);
        return this;
    }

    @Override
    public TableBuilder alias(String name) {
        this.rdbTableMetaData.setAlias(name);
        return this;
    }

    @Override
    public void commit() throws SQLException {
        RDBTableMetaData old = this.parser.parse(this.rdbTableMetaData.getName());
        if (null != old) {
            this.database.reloadTable(old);
            this.database.alterTable(this.rdbTableMetaData);
        } else {
            this.database.createTable(this.rdbTableMetaData);
        }
    }
}

