/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.IndexMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;

public class CommonCreateIndexRender {
    public static List<SQL> buildCreateIndexSql(RDBTableMetaData table) {
        return table.getIndexes().stream().map(index -> CommonCreateIndexRender.buildIndex(table.getName(), index, table)).collect(Collectors.toList());
    }

    public static SQL buildIndex(String table, IndexMetaData index, RDBTableMetaData tableMeta) {
        SqlAppender appender = new SqlAppender();
        appender.addSpc("create", index.isUnique() ? "unique" : "", "index", index.getIndexName(), "on", table, "(");
        for (IndexMetaData.IndexColumn indexColumn : index.getColumnName()) {
            appender.add(tableMeta.getDatabaseMetaData().getDialect().buildColumnName(null, indexColumn.getColumn()), " ", indexColumn.getSort() == null ? "" : indexColumn.getSort());
            appender.add(",");
        }
        appender.removeLast();
        appender.add(")");
        return new SimpleSQL(appender.toString());
    }
}

