/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.expand;

import java.sql.Blob;
import java.sql.Clob;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.rdb.meta.converter.BlobValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.ClobValueConverter;
import org.hswebframework.utils.StringUtils;

public class SimpleMapWrapper
implements ObjectWrapper<Map<String, Object>> {
    private static final BlobValueConverter blobValueConverter = new BlobValueConverter();
    private static final ClobValueConverter clobValueConverter = new ClobValueConverter();

    public Class<LinkedHashMap> getType() {
        return LinkedHashMap.class;
    }

    public Map<String, Object> newInstance() {
        return new LinkedHashMap<String, Object>();
    }

    public void wrapper(Map<String, Object> instance, int index, String attr, Object value) {
        if ("ROWNUM_".equals(attr.toUpperCase())) {
            return;
        }
        this.putValue(instance, attr, value);
    }

    public boolean done(Map<String, Object> instance) {
        return true;
    }

    protected Object convertValue(Object value) {
        if (value instanceof Blob) {
            return blobValueConverter.getValue(value);
        }
        if (value instanceof Clob) {
            return clobValueConverter.getValue(value);
        }
        return value;
    }

    public void putValue(Map<String, Object> instance, String attr, Object value) {
        value = this.convertValue(value);
        if (attr.contains(".")) {
            String[] attrs = StringUtils.splitFirst((String)attr, (String)"[.]");
            String attr_ob_name = attrs[0];
            String attr_ob_attr = attrs[1];
            Object object = instance.computeIfAbsent(attr_ob_name, k -> this.newInstance());
            if (object instanceof Map) {
                Map objectMap = (Map)object;
                this.putValue(objectMap, attr_ob_attr, value);
            }
        } else {
            instance.put(attr, value);
        }
    }
}

