/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.meta.Correlation;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.utils.StringUtils;

public abstract class SimpleWhereSqlBuilder {
    private Set<String> doNotTransformationValueTermType = Stream.of("isnull", "notnull", "empty", "nempty").collect(Collectors.toSet());

    protected String getTableAlias(RDBTableMetaData metaData, String field) {
        if (!field.contains(".")) {
            return metaData.getAlias();
        }
        field = field.split("[.]")[0];
        Correlation correlation = metaData.getCorrelation(field);
        if (correlation != null) {
            return correlation.getAlias();
        }
        return metaData.getAlias();
    }

    public void buildWhere(RDBTableMetaData metaData, String prefix, List<Term> terms, SqlAppender appender, Set<String> needSelectTable) {
        if (terms == null || terms.isEmpty()) {
            return;
        }
        int index = -1;
        String prefixTmp = StringUtils.concat((Object[])new Object[]{prefix, StringUtils.isNullOrEmpty((Object)prefix) ? "" : "."});
        for (Term term : terms) {
            ++index;
            boolean nullTerm = StringUtils.isNullOrEmpty((Object)term.getColumn());
            RDBColumnMetaData column = metaData.findColumn(term.getColumn());
            if (!(term instanceof SqlTerm) ? !nullTerm && column == null || !nullTerm && StringUtils.isNullOrEmpty((Object)term.getValue()) || nullTerm && term.getTerms().isEmpty() : StringUtils.isNullOrEmpty((Object)((SqlTerm)term).getSql())) continue;
            String tableAlias = null;
            if (column != null) {
                tableAlias = this.getTableAlias(metaData, term.getColumn());
                needSelectTable.add(tableAlias);
            }
            prefix = StringUtils.concat((Object[])new Object[]{prefixTmp, "terms[", index, "]"});
            appender.add(StringUtils.concat((Object[])new Object[]{" ", term.getType().toString().toUpperCase(), " "}));
            if (!term.getTerms().isEmpty()) {
                SqlAppender nest = new SqlAppender();
                this.buildWhere(metaData, prefix, term.getTerms(), nest, needSelectTable);
                if (nest.isEmpty()) {
                    appender.removeLast();
                    continue;
                }
                if (nullTerm) {
                    nest.removeFirst();
                }
                appender.add("(");
                if (!nullTerm) {
                    appender.add(new Object[]{this.getDialect().buildCondition(prefix, term, column, tableAlias)});
                }
                appender.addAll(nest);
                appender.add(")");
                continue;
            }
            if (nullTerm) continue;
            appender.add(new Object[]{this.getDialect().buildCondition(prefix, term, column, tableAlias)});
        }
    }

    protected Object transformationValue(RDBColumnMetaData column, Term term) {
        Object tmp;
        Object value = term.getValue();
        if (value != null && column.getValueConverter() != null) {
            value = column.getValueConverter().getData(value);
        }
        if (value != null && column.getOptionConverter() != null && null != (tmp = column.getOptionConverter().converterData(value))) {
            value = tmp;
        }
        return value;
    }

    public abstract Dialect getDialect();
}

