/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.CommonSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleWhereSqlBuilder;

public class SimpleSelectTotalSqlRender
extends CommonSqlRender<QueryParam> {
    private Dialect dialect;

    public SimpleSelectTotalSqlRender(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public SQL render(RDBTableMetaData metaData, QueryParam param) {
        return new SimpleSelectSqlRenderProcess(metaData, param).process();
    }

    class SimpleSelectSqlRenderProcess
    extends SimpleWhereSqlBuilder {
        private RDBTableMetaData metaData;
        private QueryParam param;
        private SqlAppender whereSql = new SqlAppender();
        private Set<String> needSelectTable = new LinkedHashSet<String>();

        public SimpleSelectSqlRenderProcess(RDBTableMetaData metaData, QueryParam param) {
            this.metaData = metaData;
            this.param = param;
            this.buildWhere(metaData, "", param.getTerms(), this.whereSql, this.needSelectTable);
            if (!this.whereSql.isEmpty()) {
                this.whereSql.removeFirst();
            }
        }

        public SQL process() {
            SqlAppender appender = new SqlAppender();
            appender.add("SELECT count(0) as ", SimpleSelectTotalSqlRender.this.dialect.getQuoteStart(), "total", SimpleSelectTotalSqlRender.this.dialect.getQuoteEnd());
            appender.add(" FROM ", this.metaData.getName(), " ", this.metaData.getAlias());
            this.needSelectTable.stream().filter(table -> !table.equals(this.metaData.getName()) && this.metaData.getCorrelation((String)table) != null).map(table -> this.metaData.getCorrelation((String)table)).sorted().forEach(correlation -> {
                appender.addSpc(new Object[]{"", correlation.getJoin(), correlation.getTargetTable(), correlation.getAlias(), "ON"});
                SqlAppender joinOn = new SqlAppender();
                this.buildWhere(this.metaData.getDatabaseMetaData().getTableMetaData(correlation.getTargetTable()), "", correlation.getTerms(), joinOn, new HashSet<String>());
                if (!joinOn.isEmpty()) {
                    joinOn.removeFirst();
                }
                appender.addAll(joinOn);
            });
            if (!this.whereSql.isEmpty()) {
                appender.add(" WHERE ", "").addAll(this.whereSql);
            }
            String sql = appender.toString();
            SimpleSQL simpleSQL = new SimpleSQL(sql, this.param);
            return simpleSQL;
        }

        @Override
        public Dialect getDialect() {
            return SimpleSelectTotalSqlRender.this.dialect;
        }
    }
}

