/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hswebframework.ezorm.core.DefaultValue;
import org.hswebframework.ezorm.core.param.InsertParam;
import org.hswebframework.ezorm.rdb.executor.BindSQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.Sql;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInsertSqlRender
implements SqlRender<InsertParam> {
    PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected SimpleSQL createSingleSql(RDBTableMetaData metaData, Object data, Object param, String valueExpressionPrefix) {
        Dialect dialect = metaData.getDatabaseMetaData().getDialect();
        SqlAppender appender = new SqlAppender();
        ArrayList columns = new ArrayList();
        ArrayList valuesExpression = new ArrayList();
        HashMap mapValue = new HashMap();
        metaData.getColumns().forEach(column -> {
            Object value = null;
            String propertyName = null;
            try {
                propertyName = column.getAlias();
                value = this.propertyUtils.getProperty(data, propertyName);
            }
            catch (Exception e) {
                try {
                    propertyName = column.getName();
                    value = this.propertyUtils.getProperty(data, propertyName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (value == null) {
                DefaultValue defaultValue = column.getDefaultValue();
                if (defaultValue != null && !((value = defaultValue.get()) instanceof Sql)) {
                    try {
                        this.propertyUtils.setProperty(data, propertyName, value);
                    }
                    catch (Exception ignore) {
                        this.logger.warn("set property error", (Throwable)ignore);
                    }
                }
                if (this.logger.isInfoEnabled() && value != null) {
                    this.logger.info("{}\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c:{}", (Object)propertyName, value);
                }
            }
            if (value != null && column.getValueConverter() != null) {
                Object new_value = column.getValueConverter().getData(value);
                if (column.getOptionConverter() != null) {
                    new_value = column.getOptionConverter().converterData(new_value);
                }
                if (value != new_value && !value.equals(new_value)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("{} \u8f6c\u6362value:{}\u4e3a:{}", new Object[]{propertyName, value, new_value});
                    }
                    value = new_value;
                }
            }
            if (null == value) {
                return;
            }
            mapValue.put(propertyName, value);
            columns.add(dialect.buildColumnName(null, column.getName()));
            if (value instanceof Sql) {
                valuesExpression.add(((Sql)value).getSql());
            } else {
                valuesExpression.add(this.getParamString(valueExpressionPrefix, propertyName, (RDBColumnMetaData)column).toString());
            }
        });
        appender.add("INSERT INTO ", metaData.getName(), " (").add(String.join((CharSequence)",", columns.toArray(new String[columns.size()])), ")VALUES(").add(String.join((CharSequence)",", valuesExpression.toArray(new String[valuesExpression.size()])), ")");
        return new SimpleSQL(appender.toString(), mapValue);
    }

    @Override
    public SQL render(RDBTableMetaData metaData, InsertParam param) {
        Object data = Objects.requireNonNull(param.getData(), "param can not be null!");
        if (data == null) {
            throw new NullPointerException();
        }
        List<Object> datas = null;
        if (data instanceof Collection) {
            datas = new ArrayList((Collection)data);
        } else if (data instanceof Object[]) {
            datas = Arrays.asList((Object[])data);
        }
        if (datas == null) {
            SimpleSQL simpleSQL = this.createSingleSql(metaData, data, param, "data.");
            param.setData(simpleSQL.getParams());
            simpleSQL.setParams(param);
            return simpleSQL;
        }
        SimpleSQL firstSql = this.createSingleSql(metaData, datas.get(0), param, "data[0].");
        ArrayList<BindSQL> bindSQLS = new ArrayList<BindSQL>();
        ArrayList<Object> newParam = new ArrayList<Object>();
        newParam.add(firstSql.getParams());
        for (int i = 1; i < datas.size(); ++i) {
            SimpleSQL sql = this.createSingleSql(metaData, datas.get(i), param, "data[" + i + "].");
            newParam.add(sql.getParams());
            sql.setParams(param);
            bindSQLS.add(new BindSQL(sql));
        }
        firstSql.setBindSQLs(bindSQLS);
        param.setData(newParam);
        firstSql.setParams(param);
        return firstSql;
    }

    protected SqlAppender getParamString(String prefix, String paramName, RDBColumnMetaData rdbColumnMetaData) {
        return new SqlAppender().add("#{", prefix, paramName, "}");
    }
}

