/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.oracle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.BindSQL;
import org.hswebframework.ezorm.rdb.executor.EmptySQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.utils.StringUtils;

public class OracleMetaAlterRender
implements SqlRender<Boolean> {
    private RDBDatabaseMetaData databaseMetaData;

    public OracleMetaAlterRender(RDBDatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    @Override
    public SQL render(RDBTableMetaData metaData, Boolean executeRemove) {
        RDBTableMetaData old = this.databaseMetaData.getTableMetaData(metaData.getName());
        if (old == null) {
            throw new UnsupportedOperationException("\u65e7\u8868\u4e0d\u5b58\u5728!");
        }
        ArrayList changedField = new ArrayList();
        ArrayList addedField = new ArrayList();
        ArrayList deletedField = new ArrayList();
        if (executeRemove.booleanValue()) {
            old.getColumns().forEach(oldField -> {
                RDBColumnMetaData newMeta = metaData.findColumn(oldField.getName());
                if (newMeta == null) {
                    newMeta = metaData.getColumns().stream().filter(columnMetaData -> oldField.getName().equals(columnMetaData.getProperty("old-name").getValue())).findFirst().orElse(null);
                }
                if (newMeta == null || !newMeta.getName().equals(oldField.getName())) {
                    deletedField.add(oldField);
                }
            });
        }
        metaData.getColumns().forEach(newField -> {
            RDBColumnMetaData oldField;
            String oldName = (String)newField.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = newField.getName();
            }
            if ((oldField = old.findColumn(oldName)) == null) {
                addedField.add(newField);
            } else if (!(newField.getName().equals(oldField.getName()) && newField.getDataType().equals(oldField.getDataType()) && newField.getComment().equals(oldField.getComment()) && oldField.isNotNull() == newField.isNotNull())) {
                changedField.add(newField);
            }
        });
        LinkedList<BindSQL> bind = new LinkedList<BindSQL>();
        ArrayList<String> comments = new ArrayList<String>();
        String newTableComment = metaData.getComment();
        String oldTableComment = old.getComment();
        if (newTableComment == null) {
            newTableComment = "";
        }
        if (oldTableComment == null) {
            oldTableComment = "";
        }
        if (!newTableComment.equals(oldTableComment)) {
            comments.add(String.format("COMMENT ON TABLE %s IS '%s'", metaData.getName(), metaData.getComment()));
        }
        if (addedField.isEmpty() && changedField.isEmpty() && deletedField.isEmpty() && comments.isEmpty()) {
            return new EmptySQL();
        }
        deletedField.forEach(column -> {
            String dropSql = String.format("ALTER TABLE %s DROP COLUMN \"%s\"", metaData.getName(), column.getName().toUpperCase());
            SimpleSQL simpleSQL = new SimpleSQL(dropSql, column);
            BindSQL bindSQL = new BindSQL();
            bindSQL.setSql(simpleSQL);
            bindSQL.setToField(column.getName());
            bind.add(bindSQL);
        });
        addedField.forEach(column -> {
            SqlAppender append = new SqlAppender();
            append.add("ALTER TABLE ", metaData.getName(), " ADD \"", column.getName().toUpperCase(), "\" ", column.getDataType());
            if (column.isNotNull()) {
                append.add(" NOT NULL");
            }
            if (column.isPrimaryKey()) {
                append.add(" PRIMARY KEY ");
            }
            if (StringUtils.isNullOrEmpty((Object)column.getComment())) {
                comments.add(String.format("COMMENT ON COLUMN %s.\"%s\" is '%s'", metaData.getName(), column.getName().toUpperCase(), column.getAlias()));
            } else {
                comments.add(String.format("COMMENT ON COLUMN %s.\"%s\" is '%s'", metaData.getName(), column.getName().toUpperCase(), column.getComment()));
            }
            SimpleSQL simpleSQL = new SimpleSQL(append.toString(), column);
            BindSQL bindSQL = new BindSQL();
            bindSQL.setSql(simpleSQL);
            bindSQL.setToField(column.getName());
            bind.add(bindSQL);
        });
        changedField.forEach(column -> {
            String oldName = (String)column.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = column.getName();
            }
            RDBColumnMetaData oldColumn = old.findColumn(oldName);
            if (!oldName.equals(column.getName())) {
                SqlAppender renameSql = new SqlAppender();
                renameSql.add("ALTER TABLE ", metaData.getName(), " RENAME COLUMN \"", oldName.toUpperCase(), "\" TO \"", column.getName().toUpperCase(), "\"");
                BindSQL bindSQL = new BindSQL();
                bindSQL.setSql(new SimpleSQL(renameSql.toString()));
                bind.add(bindSQL);
                metaData.renameColumn(oldName, column.getName());
            }
            if (!oldColumn.getDataType().equals(column.getDataType()) || oldColumn.isNotNull() != column.isNotNull()) {
                SqlAppender append = new SqlAppender();
                append.add("ALTER TABLE ", metaData.getName(), " MODIFY \"", column.getName().toUpperCase(), "\" ", column.getDataType());
                if (oldColumn.isNotNull() != column.isNotNull()) {
                    if (column.isNotNull()) {
                        append.add(" NOT NULL");
                    } else {
                        append.add(" NULL");
                    }
                }
                SimpleSQL simpleSQL = new SimpleSQL(append.toString(), column);
                BindSQL bindSQL = new BindSQL();
                bindSQL.setSql(simpleSQL);
                bindSQL.setToField(column.getName());
                bind.add(bindSQL);
            }
            String nc = column.getComment();
            String oc = oldColumn.getComment();
            if (nc == null) {
                nc = "";
            }
            if (oc == null) {
                oc = "";
            }
            if (nc.equals(oc)) {
                return;
            }
            if (!StringUtils.isNullOrEmpty((Object)nc)) {
                comments.add(String.format("comment on column %s.\"%s\" is '%s'", metaData.getName(), column.getName().toUpperCase(), nc));
            }
        });
        LinkedList commentSql = new LinkedList(comments.stream().map(s -> {
            BindSQL binSql = new BindSQL();
            binSql.setSql(new SimpleSQL((String)s, s));
            return binSql;
        }).collect(Collectors.toList()));
        SQL sql = null;
        if (bind.isEmpty()) {
            return new EmptySQL();
        }
        bind.addAll(commentSql);
        if (!bind.isEmpty()) {
            sql = ((BindSQL)bind.get(0)).getSql();
            bind.removeFirst();
        }
        if (sql != null && !bind.isEmpty()) {
            ((SimpleSQL)sql).setBindSQLs(bind);
        }
        return sql;
    }
}

