/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.mysql;

import java.util.Set;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.utils.StringUtils;

public class MysqlMetaCreateRender
implements SqlRender {
    public SQL render(RDBTableMetaData metaData, Object param) {
        SqlAppender appender = new SqlAppender();
        Set<RDBColumnMetaData> RDBColumnMetaDatas = metaData.getColumns();
        if (RDBColumnMetaDatas.isEmpty()) {
            throw new UnsupportedOperationException("\u672a\u6307\u5b9a\u4efb\u4f55\u5b57\u6bb5");
        }
        appender.add("\nCREATE TABLE ", metaData.getName(), "(");
        RDBColumnMetaDatas.forEach(fieldMetaData -> {
            appender.add("\n\t`", fieldMetaData.getName(), "` ").add(fieldMetaData.getDataType());
            if (fieldMetaData.isNotNull()) {
                appender.add(" not null");
            }
            if (fieldMetaData.isPrimaryKey()) {
                appender.add(" primary key");
            }
            if (!StringUtils.isNullOrEmpty((Object)fieldMetaData.getComment())) {
                appender.add(String.format(" COMMENT '%s'", fieldMetaData.getComment()));
            }
            appender.add(",");
        });
        appender.removeLast();
        appender.add("\n)ENGINE = InnoDB CHARACTER SET utf8 ");
        if (metaData.getComment() != null) {
            appender.add("COMMENT=", "'", metaData.getComment(), "'");
        }
        return new SimpleSQL(appender.toString(), param);
    }
}

