/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import org.hswebframework.ezorm.rdb.render.dialect.DefaultDialect;
import org.hswebframework.utils.StringUtils;

public class OracleDialect
extends DefaultDialect {
    protected OracleDialect() {
        this.defaultDataTypeMapper = meta -> meta.getJdbcType().getName().toLowerCase();
        this.setDataTypeMapper(JDBCType.CHAR, meta -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.NCHAR, meta -> StringUtils.concat((Object[])new Object[]{"nchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.VARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"varchar2(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.NVARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"nvarchar2(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.TIMESTAMP, meta -> "timestamp");
        this.setDataTypeMapper(JDBCType.TIME, meta -> "datetime");
        this.setDataTypeMapper(JDBCType.DATE, meta -> "date");
        this.setDataTypeMapper(JDBCType.TINYINT, meta -> "number(2)");
        this.setDataTypeMapper(JDBCType.SMALLINT, meta -> "number(5)");
        this.setDataTypeMapper(JDBCType.INTEGER, meta -> "integer");
        this.setDataTypeMapper(JDBCType.DOUBLE, meta -> "double");
        this.setDataTypeMapper(JDBCType.CLOB, meta -> "clob");
        this.setDataTypeMapper(JDBCType.BLOB, meta -> "blob");
        this.setDataTypeMapper(JDBCType.BINARY, meta -> "blob");
        this.setDataTypeMapper(JDBCType.NUMERIC, meta -> StringUtils.concat((Object[])new Object[]{"number(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.DECIMAL, meta -> StringUtils.concat((Object[])new Object[]{"number(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.OTHER, meta -> "other");
    }

    @Override
    public String getQuoteStart() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public String doPaging(String sql, int pageIndex, int pageSize) {
        return "SELECT * FROM ( SELECT row_.*, rownum rownum_ FROM (" + sql + ") row_ )" + "WHERE rownum_ <= " + pageSize * (pageIndex + 1) + " AND rownum_ > " + pageSize * pageIndex;
    }

    @Override
    public boolean columnToUpperCase() {
        return true;
    }
}

