/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.converter;

import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.utils.DateTimeUtils;
import org.hswebframework.utils.time.DateFormatter;

public class DateTimeConverter
implements ValueConverter {
    private String format;
    private Class toType;

    public DateTimeConverter(String format, Class toType) {
        this.format = format;
        this.toType = toType;
    }

    public Object getData(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof String) {
            if (((String)value).contains(",")) {
                return Arrays.stream(((String)value).split(",")).map(DateFormatter::fromString).collect(Collectors.toList());
            }
            return DateFormatter.fromString((String)((String)value));
        }
        return value;
    }

    public Object getValue(Object data) {
        if (data instanceof Number) {
            data = new Date(((Number)data).longValue());
        }
        if (data instanceof Date) {
            if (this.toType == Date.class) {
                return data;
            }
            if (this.toType == String.class) {
                return DateTimeUtils.format((Date)((Date)data), (String)this.format);
            }
        }
        if (data instanceof String && this.toType == Date.class) {
            if (((String)data).contains(",")) {
                return Arrays.stream(((String)data).split(",")).map(DateFormatter::fromString).collect(Collectors.toList());
            }
            if ((data = DateFormatter.fromString((String)((String)data))) == null) {
                data = DateTimeUtils.formatDateString((String)((String)data), (String)this.format);
            }
        }
        return data;
    }
}

