/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.builder;

import java.sql.JDBCType;
import java.util.function.Consumer;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.builder.TableBuilder;

public interface ColumnBuilder {
    public ColumnBuilder custom(Consumer<RDBColumnMetaData> var1);

    public ColumnBuilder name(String var1);

    public ColumnBuilder alias(String var1);

    public ColumnBuilder dataType(String var1);

    public ColumnBuilder jdbcType(JDBCType var1);

    default public ColumnBuilder jdbcType(String jdbcType) {
        JDBCType.valueOf(jdbcType.toUpperCase());
        return this;
    }

    public ColumnBuilder javaType(Class var1);

    public ColumnBuilder comment(String var1);

    public ColumnBuilder notNull();

    public ColumnBuilder primaryKey();

    default public ColumnBuilder varchar(int length) {
        return this.jdbcType(JDBCType.VARCHAR).length(length);
    }

    default public ColumnBuilder number(int precision, int scale) {
        return this.jdbcType(JDBCType.NUMERIC).length(precision, scale);
    }

    default public ColumnBuilder number(int len) {
        return this.jdbcType(JDBCType.NUMERIC).length(len, 0);
    }

    default public ColumnBuilder clob() {
        return this.jdbcType(JDBCType.CLOB);
    }

    default public ColumnBuilder integer() {
        return this.jdbcType(JDBCType.INTEGER);
    }

    default public ColumnBuilder datetime() {
        return this.jdbcType(JDBCType.TIMESTAMP);
    }

    default public ColumnBuilder tinyint() {
        return this.jdbcType(JDBCType.TINYINT);
    }

    public ColumnBuilder property(String var1, Object var2);

    public ColumnBuilder length(int var1);

    public ColumnBuilder length(int var1, int var2);

    public TableBuilder commit();
}

