/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.expand.SimpleMapWrapper;
import org.hswebframework.ezorm.rdb.meta.expand.WrapperConsumer;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;

public interface SqlExecutor {
    public static final SimpleMapWrapper mapWrapper = new SimpleMapWrapper();

    public <T> List<T> list(SQL var1, ObjectWrapper<T> var2) throws SQLException;

    public <T> T single(SQL var1, ObjectWrapper<T> var2) throws SQLException;

    public void exec(SQL var1) throws SQLException;

    public int update(SQL var1) throws SQLException;

    public int delete(SQL var1) throws SQLException;

    public int insert(SQL var1) throws SQLException;

    public boolean tableExists(String var1) throws SQLException;

    default public List<Map<String, Object>> list(SQL sql) throws SQLException {
        return this.list(sql, mapWrapper);
    }

    default public List<Map<String, Object>> list(String sql, Object params) throws SQLException {
        return this.list(new SimpleSQL(sql, params));
    }

    default public <T> List<T> list(String sql, ObjectWrapper<T> wrapper) throws SQLException {
        return this.list(new SimpleSQL(sql), wrapper);
    }

    default public <T> List<T> list(String sql, Object params, ObjectWrapper<T> wrapper) throws SQLException {
        return this.list(new SimpleSQL(sql, params), wrapper);
    }

    default public void list(String sql, Object params, Consumer<Map<String, Object>> consumer) throws SQLException {
        this.list(sql, params, new WrapperConsumer(consumer));
    }

    default public void list(String sql, Consumer<Map<String, Object>> consumer) throws SQLException {
        this.list(sql, (ObjectWrapper)new WrapperConsumer(consumer));
    }

    default public List<Map<String, Object>> list(String sql) throws SQLException {
        return this.list(new SimpleSQL(sql));
    }

    default public Map<String, Object> single(SQL sql) throws SQLException {
        return this.single(sql, mapWrapper);
    }

    default public Map<String, Object> single(String sql, Object params) throws SQLException {
        return this.single(new SimpleSQL(sql, params));
    }

    default public Map<String, Object> single(String sql) throws SQLException {
        return this.single(new SimpleSQL(sql));
    }

    default public int insert(String sql, Object params) throws SQLException {
        return this.insert(new SimpleSQL(sql, params));
    }

    default public int update(String sql, Object params) throws SQLException {
        return this.update(new SimpleSQL(sql, params));
    }

    default public int update(String sql) throws SQLException {
        return this.update(new SimpleSQL(sql));
    }

    default public int delete(String sql, Object params) throws SQLException {
        return this.delete(new SimpleSQL(sql, params));
    }

    default public int delete(String sql) throws SQLException {
        return this.delete(new SimpleSQL(sql));
    }

    default public void exec(String sql) throws SQLException {
        this.exec(new SimpleSQL(sql));
    }

    default public void exec(String sql, Object params) throws SQLException {
        this.exec(new SimpleSQL(sql, params));
    }
}

