/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.symmetry.ui.test.traversal;

import org.hobsoft.symmetry.ui.ComboBox;
import org.hobsoft.symmetry.ui.Component;
import org.hobsoft.symmetry.ui.Container;
import org.hobsoft.symmetry.ui.Grid;
import org.hobsoft.symmetry.ui.Table;
import org.hobsoft.symmetry.ui.Tree;
import org.hobsoft.symmetry.ui.traversal.ComponentVisitor;
import org.hobsoft.symmetry.ui.traversal.ContainerVisitor;
import org.hobsoft.symmetry.ui.traversal.GridVisitor;
import org.hobsoft.symmetry.ui.traversal.HierarchicalComponentVisitor;
import org.hobsoft.symmetry.ui.traversal.ListBoxVisitor;
import org.hobsoft.symmetry.ui.traversal.TableVisitor;
import org.hobsoft.symmetry.ui.traversal.TreeVisitor;
import org.jmock.Mockery;

public final class MockComponentVisitors {
    private static final HierarchicalComponentVisitor<Component, Object, Exception> NULL_VISIT = new HierarchicalComponentVisitor<Component, Object, Exception>(){

        public HierarchicalComponentVisitor.Visit visit(Component component, Object parameter) throws Exception {
            return null;
        }

        public HierarchicalComponentVisitor.EndVisit endVisit(Component component, Object parameter) throws Exception {
            return HierarchicalComponentVisitor.EndVisit.VISIT_SIBLINGS;
        }
    };
    private static final HierarchicalComponentVisitor<Component, Object, Exception> NULL_END_VISIT = new HierarchicalComponentVisitor<Component, Object, Exception>(){

        public HierarchicalComponentVisitor.Visit visit(Component component, Object parameter) throws Exception {
            return HierarchicalComponentVisitor.Visit.VISIT_CHILDREN;
        }

        public HierarchicalComponentVisitor.EndVisit endVisit(Component component, Object parameter) throws Exception {
            return null;
        }
    };

    private MockComponentVisitors() {
        throw new AssertionError();
    }

    public static <P, E extends Exception> ComponentVisitor<P, E> createVisitor(Mockery mockery) {
        ComponentVisitor visitor = (ComponentVisitor)mockery.mock(ComponentVisitor.class);
        return visitor;
    }

    public static <T extends Component, P, E extends Exception> HierarchicalComponentVisitor<T, P, E> nullVisit() {
        HierarchicalComponentVisitor<Component, Object, Exception> visitor = NULL_VISIT;
        return visitor;
    }

    public static <T extends Component, P, E extends Exception> HierarchicalComponentVisitor<T, P, E> nullEndVisit() {
        HierarchicalComponentVisitor<Component, Object, Exception> visitor = NULL_END_VISIT;
        return visitor;
    }

    public static <T extends Component, P, E extends Exception> HierarchicalComponentVisitor<T, P, E> createHierarchicalVisitor(Mockery mockery) {
        HierarchicalComponentVisitor visitor = (HierarchicalComponentVisitor)mockery.mock(HierarchicalComponentVisitor.class);
        return visitor;
    }

    public static <T extends Container, P, E extends Exception> ContainerVisitor<T, P, E> createContainerVisitor(Mockery mockery) {
        ContainerVisitor visitor = (ContainerVisitor)mockery.mock(ContainerVisitor.class);
        return visitor;
    }

    public static <T extends Grid, P, E extends Exception> GridVisitor<T, P, E> createGridVisitor(Mockery mockery) {
        GridVisitor visitor = (GridVisitor)mockery.mock(GridVisitor.class);
        return visitor;
    }

    public static <T extends ComboBox<?>, P, E extends Exception> ListBoxVisitor<T, P, E> createListBoxVisitor(Mockery mockery) {
        ListBoxVisitor visitor = (ListBoxVisitor)mockery.mock(ListBoxVisitor.class);
        return visitor;
    }

    public static <T extends Table, P, E extends Exception> TableVisitor<T, P, E> createTableVisitor(Mockery mockery) {
        TableVisitor visitor = (TableVisitor)mockery.mock(TableVisitor.class);
        return visitor;
    }

    public static <T extends Tree, P, E extends Exception> TreeVisitor<T, P, E> createTreeVisitor(Mockery mockery) {
        TreeVisitor visitor = (TreeVisitor)mockery.mock(TreeVisitor.class);
        return visitor;
    }

    public static Object createVisitorParameter() {
        return "x";
    }
}

