/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.symmetry.ui.test.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hobsoft.symmetry.ui.model.ListModel;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;

public final class ListModelSupport {
    private ListModelSupport() {
        throw new AssertionError();
    }

    public static Object createItem() {
        return new Object();
    }

    public static Object[] createItems() {
        return new Object[]{ListModelSupport.createItem(), ListModelSupport.createItem(), ListModelSupport.createItem()};
    }

    public static List<Object> createItemsAsList() {
        return Arrays.asList(ListModelSupport.createItems());
    }

    public static <T> ListModel<T> mockModel(Mockery mockery, final T ... items) {
        final ListModel model = (ListModel)mockery.mock(ListModel.class);
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ListModel)this.atMost(1).of((Object)model)).getItemCount();
                this.will(1.returnValue((Object)items.length));
                for (int i = 0; i < items.length; ++i) {
                    ((ListModel)this.atMost(1).of((Object)model)).getItem(i);
                    this.will(1.returnValue((Object)items[i]));
                }
            }
        });
        return model;
    }

    public static void assertListModelEmpty(ListModel<?> actual) {
        ListModelSupport.assertListModel(Collections.<Object>emptyList(), actual);
    }

    public static void assertListModel(ListModel<?> actual, Object ... expectedItems) {
        ListModelSupport.assertListModel(Arrays.asList(expectedItems), actual);
    }

    public static void assertListModel(List<Object> expectedItems, ListModel<?> actual) {
        Assert.assertNotNull((String)"Model was null", actual);
        Assert.assertEquals((String)"Items", expectedItems, ListModelSupport.toItemList(actual));
    }

    private static <T> List<T> toItemList(ListModel<T> model) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (int index = 0; index < model.getItemCount(); ++index) {
            items.add(model.getItem(index));
        }
        return items;
    }
}

