/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.symmetry.ui.test;

import com.google.common.reflect.TypeToken;
import org.hobsoft.symmetry.ui.Component;
import org.hobsoft.symmetry.ui.test.traversal.MockComponentVisitors;
import org.hobsoft.symmetry.ui.traversal.ComponentVisitor;
import org.hobsoft.symmetry.ui.traversal.ComponentVisitors;
import org.hobsoft.symmetry.ui.traversal.HierarchicalComponentVisitor;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public abstract class AbstractComponentTest<T extends Component> {
    private Mockery mockery = new JUnit4Mockery();
    private TypeToken<T> componentType;
    private T component;

    @Before
    public final void setUpAbstractComponentTest() {
        this.componentType = this.getComponentType();
        this.component = this.createComponent();
    }

    @Test
    public void acceptWithSubvisitorReturningVisitSiblings() {
        final Object parameter = MockComponentVisitors.createVisitorParameter();
        final ComponentVisitor visitor = MockComponentVisitors.createVisitor(this.mockery);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ComponentVisitor)this.oneOf(visitor)).visit(AbstractComponentTest.this.componentType, AbstractComponentTest.this.component, parameter);
                this.will(1.returnValue((Object)ComponentVisitors.nullHierarchicalVisitor()));
            }
        });
        Assert.assertEquals((Object)HierarchicalComponentVisitor.EndVisit.VISIT_SIBLINGS, (Object)this.component.accept(visitor, parameter));
    }

    @Test
    public void acceptWithSubvisitorReturningSkipSiblings() {
        final Object parameter = MockComponentVisitors.createVisitorParameter();
        final ComponentVisitor visitor = MockComponentVisitors.createVisitor(this.mockery);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ComponentVisitor)this.oneOf(visitor)).visit(AbstractComponentTest.this.componentType, AbstractComponentTest.this.component, parameter);
                this.will(2.returnValue((Object)ComponentVisitors.skipSiblings()));
            }
        });
        Assert.assertEquals((Object)HierarchicalComponentVisitor.EndVisit.SKIP_SIBLINGS, (Object)this.component.accept(visitor, parameter));
    }

    @Test
    public void acceptWithSubvisitorReturningNullVisit() {
        Object parameter = MockComponentVisitors.createVisitorParameter();
        ComponentVisitor visitor = MockComponentVisitors.createVisitor(this.mockery);
        this.mockery.checking((ExpectationBuilder)new Expectations(this, visitor, parameter){
            final /* synthetic */ ComponentVisitor val$visitor;
            final /* synthetic */ Object val$parameter;
            final /* synthetic */ AbstractComponentTest this$0;
        });
        Assert.assertEquals((Object)HierarchicalComponentVisitor.EndVisit.VISIT_SIBLINGS, (Object)this.component.accept(visitor, parameter));
    }

    @Test
    public void acceptWithSubvisitorReturningNullEndVisit() {
        Object parameter = MockComponentVisitors.createVisitorParameter();
        ComponentVisitor visitor = MockComponentVisitors.createVisitor(this.mockery);
        this.mockery.checking((ExpectationBuilder)new Expectations(this, visitor, parameter){
            final /* synthetic */ ComponentVisitor val$visitor;
            final /* synthetic */ Object val$parameter;
            final /* synthetic */ AbstractComponentTest this$0;
        });
        Assert.assertEquals((Object)HierarchicalComponentVisitor.EndVisit.VISIT_SIBLINGS, (Object)this.component.accept(visitor, parameter));
    }

    @Test
    public void acceptWithNullSubvisitor() {
        final Object parameter = MockComponentVisitors.createVisitorParameter();
        final ComponentVisitor visitor = MockComponentVisitors.createVisitor(this.mockery);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ComponentVisitor)this.oneOf(visitor)).visit(AbstractComponentTest.this.componentType, AbstractComponentTest.this.component, parameter);
                this.will(5.returnValue(null));
            }
        });
        Assert.assertEquals((Object)HierarchicalComponentVisitor.EndVisit.VISIT_SIBLINGS, (Object)this.component.accept(visitor, parameter));
    }

    @Test(expected=NullPointerException.class)
    public void acceptWithNullVisitor() {
        this.component.accept((ComponentVisitor)null, MockComponentVisitors.createVisitorParameter());
    }

    protected final Mockery getMockery() {
        return this.mockery;
    }

    protected final T getComponent() {
        return this.component;
    }

    protected abstract T createComponent();

    protected abstract TypeToken<T> getComponentType();
}

