/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.symmetry.ui.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.hobsoft.entangle.Observable;
import org.hobsoft.entangle.ObservableEvent;
import org.hobsoft.entangle.ObservableListener;
import org.hobsoft.symmetry.ui.ListBox;
import org.hobsoft.symmetry.ui.model.ListModel;
import org.hobsoft.symmetry.ui.model.ListModels;

class ListBoxSelectedItemsObservable<T>
implements Observable<List<T>> {
    private final ListBox<T> listBox;

    public ListBoxSelectedItemsObservable(ListBox<T> listBox) {
        this.listBox = listBox;
    }

    public void addObservableListener(final ObservableListener<List<T>> listener) {
        PropertyChangeListener selectedIndexesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ListBoxSelectedItemsObservable source = ListBoxSelectedItemsObservable.this;
                int[] oldSelectedIndexes = (int[])event.getOldValue();
                int[] newSelectedIndexes = (int[])event.getNewValue();
                List oldSelectedItems = ListModels.getItems((ListModel)ListBoxSelectedItemsObservable.this.listBox.getModel(), (int[])oldSelectedIndexes);
                List newSelectedItems = ListModels.getItems((ListModel)ListBoxSelectedItemsObservable.this.listBox.getModel(), (int[])newSelectedIndexes);
                listener.valueChanged(new ObservableEvent((Observable)source, (Object)oldSelectedItems, (Object)newSelectedItems));
            }
        };
        this.listBox.addPropertyChangeListener("selectedIndexes", selectedIndexesListener);
    }

    public void removeObservableListener(ObservableListener<List<T>> listener) {
    }

    public List<T> getValue() {
        return this.listBox.getSelectedItemsAsList();
    }

    public void setValue(List<T> value) {
        this.listBox.setSelectedItems(value);
    }
}

