/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.symmetry.ui.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.hobsoft.entangle.Observable;
import org.hobsoft.entangle.ObservableEvent;
import org.hobsoft.entangle.ObservableListener;
import org.hobsoft.symmetry.ui.ComboBox;

class ComboBoxSelectedItemObservable<T>
implements Observable<T> {
    private final ComboBox<T> comboBox;

    public ComboBoxSelectedItemObservable(ComboBox<T> comboBox) {
        this.comboBox = comboBox;
    }

    public void addObservableListener(final ObservableListener<T> listener) {
        PropertyChangeListener selectedIndexListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ComboBoxSelectedItemObservable source = ComboBoxSelectedItemObservable.this;
                int oldSelectedIndex = (Integer)event.getOldValue();
                int newSelectedIndex = (Integer)event.getNewValue();
                Object oldSelectedItem = ComboBoxSelectedItemObservable.getItem(ComboBoxSelectedItemObservable.this.comboBox, oldSelectedIndex);
                Object newSelectedItem = ComboBoxSelectedItemObservable.getItem(ComboBoxSelectedItemObservable.this.comboBox, newSelectedIndex);
                listener.valueChanged(new ObservableEvent((Observable)source, oldSelectedItem, newSelectedItem));
            }
        };
        this.comboBox.addPropertyChangeListener("selectedIndex", selectedIndexListener);
    }

    public void removeObservableListener(ObservableListener<T> listener) {
    }

    public T getValue() {
        return (T)this.comboBox.getSelectedItem();
    }

    public void setValue(T value) {
        this.comboBox.setSelectedItem(value);
    }

    private static <T> T getItem(ComboBox<T> comboBox, int index) {
        return (T)(index != -1 ? comboBox.getModel().getItem(index) : null);
    }
}

