/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.spring.resttemplatelogger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.hobsoft.spring.resttemplatelogger.LogFormatter;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MimeType;
import org.springframework.util.StreamUtils;

public class DefaultLogFormatter
implements LogFormatter {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;

    @Override
    public String formatRequest(HttpRequest request, byte[] body) {
        String formattedBody = this.formatBody(body, this.getCharset((HttpMessage)request));
        return String.format("Request: %s %s %s", request.getMethod(), request.getURI(), formattedBody);
    }

    @Override
    public String formatResponse(ClientHttpResponse response) throws IOException {
        String formattedBody = this.formatBody(StreamUtils.copyToByteArray((InputStream)response.getBody()), this.getCharset((HttpMessage)response));
        return String.format("Response: %s %s", response.getStatusCode().value(), formattedBody);
    }

    protected String formatBody(byte[] body, Charset charset) {
        return new String(body, charset);
    }

    protected Charset getCharset(HttpMessage message) {
        return Optional.ofNullable(message.getHeaders().getContentType()).map(MimeType::getCharset).orElse(DEFAULT_CHARSET);
    }
}

