/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.spring.resttemplatelogger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MimeType;
import org.springframework.util.StreamUtils;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private final Log log;

    public LoggingInterceptor(Log log) {
        this.log = log;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Request: %s %s %s", request.getMethod(), request.getURI(), new String(body, LoggingInterceptor.getCharset((HttpMessage)request))));
        }
        ClientHttpResponse response = execution.execute(request, body);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Response: %s %s", response.getStatusCode().value(), StreamUtils.copyToString((InputStream)response.getBody(), (Charset)LoggingInterceptor.getCharset((HttpMessage)response))));
        }
        return response;
    }

    private static Charset getCharset(HttpMessage message) {
        return Optional.ofNullable(message.getHeaders().getContentType()).map(MimeType::getCharset).orElse(DEFAULT_CHARSET);
    }
}

