/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.spring.resttemplatelogger;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hobsoft.spring.resttemplatelogger.LoggingInterceptor;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class LoggingCustomizer
implements RestTemplateCustomizer {
    private final Log log;

    public LoggingCustomizer() {
        this(LogFactory.getLog(LoggingCustomizer.class));
    }

    public LoggingCustomizer(Log log) {
        this.log = log;
    }

    public void customize(RestTemplate restTemplate) {
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(restTemplate.getRequestFactory()));
        restTemplate.getInterceptors().add(new LoggingInterceptor(this.log));
    }
}

