/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.animate;

import net.minecraft.util.Mth;

public interface IAnimatable {
    public long getAnimationStartTime();

    public void setAnimationStartTime(long var1);

    public long getAnimationDuration();

    public void setAnimationDuration(long var1);

    default public void runningTime() {
    }

    default public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    default public long getEndTimeMillis() {
        return this.getAnimationStartTime() + this.getAnimationDuration();
    }

    default public long getRemainingTime() {
        return Mth.clamp((long)(this.getEndTimeMillis() - this.getCurrentTimeMillis()), (long)0L, (long)this.getAnimationDuration());
    }

    default public float getRemainingRatio() {
        long remaining = this.getRemainingTime();
        return remaining == 0L ? 0.0f : (float)remaining / (float)this.getAnimationDuration();
    }

    default public long getElapsedTime() {
        return Mth.clamp((long)(this.getCurrentTimeMillis() - this.getAnimationStartTime()), (long)0L, (long)this.getAnimationDuration());
    }

    default public float getElapsedRatio() {
        long elapsed = this.getElapsedTime();
        return elapsed == 0L ? 0.0f : (float)elapsed / (float)this.getAnimationDuration();
    }

    default public boolean isAnimating() {
        return this.getCurrentTimeMillis() < this.getEndTimeMillis();
    }

    default public boolean isAnimationEnd() {
        return this.getCurrentTimeMillis() >= this.getEndTimeMillis();
    }

    default public void startAnimationDuring(long duration) {
        this.setAnimationStartTime(this.getCurrentTimeMillis());
        this.setAnimationDuration(duration);
    }

    default public void startAnimationAfter(long after) {
        this.setAnimationStartTime(this.getCurrentTimeMillis() + after);
    }

    default public void startAnimation() {
        this.setAnimationStartTime(this.getCurrentTimeMillis());
    }
}

