/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.tree.debug;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.hiedacamellia.immersiveui.client.debug.DebugEntry;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.TreeEntryWidget;

public class DebugTreeEntryWidget
extends TreeEntryWidget<DebugEntry> {
    public DebugTreeEntryWidget(Component message, Font font) {
        super(message, font);
        this.foldWidth = 20;
        this.selfHeight = 20;
        this.selfWidth += 40;
    }

    public static DebugTreeEntryWidget create(DebugEntry data, Component component, Font font) {
        DebugTreeEntryWidget widget = new DebugTreeEntryWidget(component, font);
        widget.setData(data);
        widget.updateWidget();
        return widget;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.hasChild()) {
            IUIGuiUtils.drawCenteredString(guiGraphics, this.font, this.fold ? this.foldComponent : this.unfoldComponent, (float)(this.getX() + this.foldWidth / 2), (float)(this.getY() + this.selfHeight / 2), 0xFFFFFF, false);
            FormattedCharSequence formattedCharSequence = this.getMessage().getVisualOrderText();
            float f = (float)this.getX() + (float)this.foldWidth;
            float f2 = (float)this.getY() + (float)this.selfHeight / 2.0f;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, formattedCharSequence, f, f2 - 9.0f / 2.0f, 0xFFFFFF, false);
        } else {
            FormattedCharSequence formattedCharSequence = this.getMessage().getVisualOrderText();
            float f = this.getX();
            float f3 = (float)this.getY() + (float)this.selfHeight / 2.0f;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, formattedCharSequence, f, f3 - 9.0f / 2.0f, 0xFFFFFF, false);
        }
        if (this.fold) {
            return;
        }
        this.renderChildren(guiGraphics, mouseX, mouseY, v);
    }

    @Override
    public boolean shouldAccept(double mouseX, double mouseY) {
        return false;
    }
}

