/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar.delay;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.animate.IAnimatable;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base.BaseBarWidget;

public class DelayBarWidget
extends BaseBarWidget
implements IAnimatable {
    protected int delayIncreaseColor = -61167;
    protected int delayDecreaseColor = -15658497;
    protected long delay = 500L;
    protected float startProgress = 0.0f;
    protected float targetProgress = 0.0f;
    protected long delayStartTime = 0L;

    public DelayBarWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    public void setDelay(long delay) {
        this.setAnimationDuration(delay);
    }

    public void setDelayIncreaseColor(int color) {
        this.delayIncreaseColor = color;
    }

    public void setDelayDecreaseColor(int color) {
        this.delayDecreaseColor = color;
    }

    protected boolean isIncrease() {
        return this.targetProgress > this.progress;
    }

    protected boolean isDecrease() {
        return this.targetProgress < this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.targetProgress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
        this.startProgress = this.progress;
        this.startAnimation();
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        this.runningTime();
        super.renderWidget(guiGraphics, i, i1, v);
    }

    @Override
    public void renderBeforeBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.isIncrease()) {
            if (this.isVertical) {
                if (this.isReverse) {
                    IUIGuiUtils.fill(guiGraphics, this.getX(), (float)(this.getY() + this.height) - (float)this.height * this.targetProgress, this.width, (float)this.height * this.targetProgress, this.delayIncreaseColor);
                } else {
                    IUIGuiUtils.fill(guiGraphics, this.getX(), this.getY(), this.width, (float)this.height * this.targetProgress, this.delayIncreaseColor);
                }
            } else if (this.isReverse) {
                IUIGuiUtils.fill(guiGraphics, (float)(this.getX() + this.width) - (float)this.width * this.targetProgress, this.getY(), (float)this.width * this.targetProgress, this.height, this.delayIncreaseColor);
            } else {
                IUIGuiUtils.fill(guiGraphics, this.getX(), this.getY(), (float)this.width * this.targetProgress, this.height, this.delayIncreaseColor);
            }
        }
    }

    @Override
    public void renderAfterBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.isDecrease()) {
            if (this.isVertical) {
                if (this.isReverse) {
                    IUIGuiUtils.fill(guiGraphics, this.getX(), (float)(this.getY() + this.height) - (float)this.height * (this.progress - this.targetProgress), this.width, (float)this.height * (this.progress - this.targetProgress), this.delayDecreaseColor);
                } else {
                    IUIGuiUtils.fill(guiGraphics, this.getX(), (float)this.getY() + (float)this.height * this.targetProgress, this.width, (float)this.height * (this.progress - this.targetProgress), this.delayDecreaseColor);
                }
            } else if (this.isReverse) {
                IUIGuiUtils.fill(guiGraphics, (float)(this.getX() + this.width) - (float)this.width * (this.progress - this.targetProgress), this.getY(), (float)this.width * (this.progress - this.targetProgress), this.height, this.delayDecreaseColor);
            } else {
                IUIGuiUtils.fill(guiGraphics, (float)this.getX() + (float)this.width * this.targetProgress, this.getY(), (float)this.width * (this.progress - this.targetProgress), this.height, this.delayDecreaseColor);
            }
        }
    }

    @Override
    public long getAnimationStartTime() {
        return this.delayStartTime;
    }

    @Override
    public void setAnimationStartTime(long time) {
        this.delayStartTime = time;
    }

    @Override
    public long getAnimationDuration() {
        return this.delay;
    }

    @Override
    public void setAnimationDuration(long duration) {
        this.delay = duration;
    }

    @Override
    public void runningTime() {
        if (this.isAnimationEnd()) {
            return;
        }
        float progressDelta = this.getElapsedRatio();
        if (this.isIncrease()) {
            this.progress = Mth.lerp((float)progressDelta, (float)this.startProgress, (float)this.targetProgress);
            if (this.progress >= this.targetProgress) {
                this.progress = this.targetProgress;
            }
        } else if (this.isDecrease()) {
            this.progress = Mth.lerp((float)progressDelta, (float)this.startProgress, (float)this.targetProgress);
            if (this.progress <= this.targetProgress) {
                this.progress = this.targetProgress;
            }
        }
    }
}

