package org.hiedacamellia.immersiveui.client.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.hiedacamellia.immersiveui.client.graphic.target.ScreenTempTarget;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(GameRenderer.class)
public class GameRendererMixin {

    @Final
    @Shadow
    private Minecraft minecraft;

    @Inject(method = "processBlurEffect()V",at = @At("HEAD"),cancellable = true)
    private void processBlurEffect(CallbackInfo ci){
        float f = (float)this.minecraft.options.getMenuBackgroundBlurriness();
        if(ScreenTempTarget.BLUR_INSTANCE ==null)return;
        if(ScreenTempTarget.BLUR_INSTANCE.use){
            if (ScreenTempTarget.getBlurEffect() != null && f >= 1.0F) {
                ScreenTempTarget.getBlurEffect().setUniform("Radius", f);
                ScreenTempTarget.getBlurEffect().process(ScreenTempTarget.BLUR_INSTANCE,((GameRenderer)(Object)this).resourcePool);
                ci.cancel();
            }
        }
    }

}
