/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.price;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.component.ComponentWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.editbox.NumberEditBox;
import org.hiedacamellia.immersiveui.client.gui.component.widget.solt.FakeItemSlot;

public class SimplePriceWidget
extends AbstractContainerWidget {
    private static final int width = 80;
    private static final int height = 20;
    private final FakeItemSlot slot;
    private final NumberEditBox editBox;
    private final ComponentWidget componentWidget;
    private final LinearLayout layout;

    public SimplePriceWidget(int x, int y) {
        this(x, y, ItemStack.EMPTY, 0);
    }

    public boolean tryAccept(ItemStack itemStack) {
        if (this.slot.isHovered()) {
            this.slot.setItemStack(itemStack);
            this.slot.setMessage(itemStack.getDisplayName());
            return true;
        }
        return false;
    }

    public SimplePriceWidget(int x, int y, ItemStack itemStack, int price) {
        super(x, y, 80, 20, (Component)Component.empty());
        this.slot = new FakeItemSlot(0, 0, itemStack.getDisplayName());
        this.slot.setItemStack(itemStack);
        this.componentWidget = new ComponentWidget(0, 0, (Component)Component.literal((String)"="));
        this.editBox = new NumberEditBox(0, 0, 30, 9, (Component)Component.empty());
        this.editBox.setInt(price);
        this.editBox.setBordered(false);
        this.layout = new LinearLayout(80, 20, LinearLayout.Orientation.HORIZONTAL);
        this.layout.setX(x);
        this.layout.setY(y);
        this.layout.spacing(2);
        this.layout.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle().paddingVertical(2).paddingHorizontal(2);
        this.layout.addChild((LayoutElement)this.slot);
        this.layout.addChild((LayoutElement)this.componentWidget);
        this.layout.addChild((LayoutElement)this.editBox);
        this.layout.arrangeElements();
    }

    public ItemStack getItemStack() {
        return this.slot.getItemStack();
    }

    public int getPrice() {
        return this.editBox.getInt();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        RenderSystem.enableBlend();
        IUIGuiUtils.fillRoundRect(guiGraphics, (float)this.getX(), (float)this.getY(), 80.0f, 20.0f, 0.05f, -70703);
        RenderSystem.disableBlend();
        this.slot.render(guiGraphics, mouseX, mouseY, v);
        this.componentWidget.render(guiGraphics, mouseX, mouseY, v);
        this.editBox.render(guiGraphics, mouseX, mouseY, v);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public List<? extends GuiEventListener> children() {
        return List.of(this.slot, this.editBox);
    }

    protected int contentHeight() {
        return 20;
    }

    protected double scrollRate() {
        return 0.0;
    }
}

