/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.layout;

import net.minecraft.client.gui.layouts.LayoutElement;
import org.hiedacamellia.immersiveui.client.gui.component.widget.layout.LayoutLocation;
import org.joml.Vector2f;

public interface ILayoutExtension
extends LayoutElement {
    default public float getTopF() {
        return this.getY();
    }

    default public float getBottomF() {
        return this.getY() + this.getHeight();
    }

    default public float getLeftF() {
        return this.getX();
    }

    default public float getRightF() {
        return this.getX() + this.getWidth();
    }

    default public float getCenterX() {
        return (float)this.getX() + (float)this.getWidth() / 2.0f;
    }

    default public float getCenterY() {
        return (float)this.getY() + (float)this.getHeight() / 2.0f;
    }

    default public Vector2f getCenter() {
        return new Vector2f(this.getCenterX(), this.getCenterY());
    }

    default public Vector2f getLocationPoint() {
        return this.getLocationPoint(this.getLayoutLocation());
    }

    default public Vector2f getLocationPoint(LayoutLocation location) {
        return switch (location) {
            case LayoutLocation.TOP -> new Vector2f(this.getCenterX(), this.getTopF());
            case LayoutLocation.BOTTOM -> new Vector2f(this.getCenterX(), this.getBottomF());
            case LayoutLocation.LEFT -> new Vector2f(this.getLeftF(), this.getCenterY());
            case LayoutLocation.RIGHT -> new Vector2f(this.getRightF(), this.getCenterY());
            case LayoutLocation.TOP_LEFT -> new Vector2f(this.getLeftF(), this.getTopF());
            case LayoutLocation.TOP_RIGHT -> new Vector2f(this.getRightF(), this.getTopF());
            case LayoutLocation.BOTTOM_LEFT -> new Vector2f(this.getLeftF(), this.getBottomF());
            case LayoutLocation.BOTTOM_RIGHT -> new Vector2f(this.getRightF(), this.getBottomF());
            case LayoutLocation.CENTER -> new Vector2f(this.getCenterX(), this.getCenterY());
            default -> this.getCenter();
        };
    }

    default public LayoutLocation getLayoutLocation() {
        return LayoutLocation.NONE;
    }

    default public void setLayoutLocation(LayoutLocation location) {
    }
}

