/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.guide;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.immersiveui.client.animate.AnimateContainer;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.guide.EmphasizeComponentWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.guide.EmphasizeRenderHelper;
import org.hiedacamellia.immersiveui.client.gui.component.widget.guide.IEmphasizeWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.layout.ILayoutExtension;
import org.joml.Vector2f;

public class EmphasizeDescriptionWidget
extends EmphasizeComponentWidget {
    protected AnimateContainer targetWidgetAnim = new AnimateContainer(500L);
    protected AnimateContainer connectAnim = new AnimateContainer(500L);
    protected AnimateContainer selfAnim = new AnimateContainer(500L);
    protected ILayoutExtension targetWidget;
    protected Vector2f targetPos = new Vector2f(0.0f, 0.0f);
    protected IEmphasizeWidget.Emphasize targetEmphasize = IEmphasizeWidget.Emphasize.LINE_UNDER;
    protected IEmphasizeWidget.Emphasize selfEmphasize = IEmphasizeWidget.Emphasize.LINE_UNDER;
    protected boolean show = false;

    public void setTargetWidget(ILayoutExtension targetWidget) {
        this.targetWidget = targetWidget;
    }

    public void setTargetEmphasize(IEmphasizeWidget.Emphasize targetEmphasize) {
        this.targetEmphasize = targetEmphasize;
    }

    public void setSelfEmphasize(IEmphasizeWidget.Emphasize selfEmphasize) {
        this.selfEmphasize = selfEmphasize;
    }

    public void setTargetPos(Vector2f targetPos) {
        this.targetPos = targetPos;
    }

    public EmphasizeDescriptionWidget(int x, int y, Component message) {
        super(x, y, message);
    }

    public void show() {
        this.show = true;
        if (this.targetWidget != null) {
            this.targetWidgetAnim.startAnimation();
            this.connectAnim.startAnimationAfter(500L);
            this.selfAnim.startAnimationAfter(1000L);
        } else {
            this.connectAnim.startAnimation();
            this.selfAnim.startAnimationAfter(500L);
        }
    }

    public void hide() {
        this.show = false;
        this.selfAnim.startAnimation();
        this.connectAnim.startAnimationAfter(500L);
        if (this.targetWidget != null) {
            this.targetWidgetAnim.startAnimationAfter(1000L);
        }
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        if (this.targetWidget != null) {
            float target = this.targetWidgetAnim.getElapsedRatio();
            float connect = this.connectAnim.getElapsedRatio();
            float self = this.selfAnim.getElapsedRatio();
            if (!this.show) {
                target = 1.0f - target;
                connect = 1.0f - connect;
                self = 1.0f - self;
            }
            EmphasizeRenderHelper.renderEmphasize(target, this.targetWidget, guiGraphics, this.getEmphasizeColor(), this.targetEmphasize);
            EmphasizeRenderHelper.connectV(connect, this.targetWidget.getLocationPoint(), this.getLocationPoint(this.getEmphasizeLocation()), guiGraphics, this.getEmphasizeColor());
            EmphasizeRenderHelper.renderEmphasize(self, this, this.getEmphasizeLocation(), guiGraphics, this.getEmphasizeColor(), this.selfEmphasize);
            guiGraphics.flush();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)self);
            IUIGuiUtils.drawString(guiGraphics, this.getMessage(), (float)(this.getX() + 1), (float)(this.getY() + 1), 0xFFFFFF, false);
            guiGraphics.flush();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            float connect = this.connectAnim.getElapsedRatio();
            float self = this.selfAnim.getElapsedRatio();
            if (!this.show) {
                connect = 1.0f - connect;
                self = 1.0f - self;
            }
            EmphasizeRenderHelper.connectV(connect, this.targetPos, this.getLocationPoint(this.getEmphasizeLocation()), guiGraphics, this.getEmphasizeColor());
            EmphasizeRenderHelper.renderEmphasize(self, this, this.getEmphasizeLocation(), guiGraphics, this.getEmphasizeColor(), this.selfEmphasize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)self);
            IUIGuiUtils.drawString(guiGraphics, this.getMessage(), (float)(this.getX() + 1), (float)(this.getY() + 1), 0xFFFFFF, false);
            guiGraphics.flush();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        pose.popPose();
    }
}

