/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.editbox;

import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMinecraftUtils;

public class NumberEditBox
extends EditBox {
    public NumberEditBox(int x, int y, int width, int height, Component message) {
        super(IUIMinecraftUtils.getFont(), x, y, width, height, message);
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.getValue());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public void setInt(int value) {
        this.setValue(String.valueOf(value));
    }

    public void setDouble(double value) {
        this.setValue(String.valueOf(value));
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (Character.isDigit(codePoint) || Character.isISOControl(codePoint) || codePoint == '.' || codePoint == '-') {
            return super.charTyped(codePoint, modifiers);
        }
        return false;
    }
}

