/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.component;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.hiedacamellia.immersiveui.client.gui.component.widget.component.ComponentWidget;

public class MultiFormattedCharSequenceWidget
extends AbstractStringWidget {
    private static final Font font = Minecraft.getInstance().font;
    protected FormattedCharSequence[] component;
    private boolean shadow;

    public static MultiFormattedCharSequenceWidget from(Component component, int width) {
        return new ComponentWidget(component).toMultiFormatted(width);
    }

    public MultiFormattedCharSequenceWidget(FormattedCharSequence ... component) {
        this(0, 0, component);
    }

    public MultiFormattedCharSequenceWidget(int x, int y, int width, List<FormattedCharSequence> component) {
        this(x, y, width, component.toArray(new FormattedCharSequence[0]));
    }

    public MultiFormattedCharSequenceWidget(int x, int y, List<FormattedCharSequence> component) {
        this(x, y, component.toArray(new FormattedCharSequence[0]));
    }

    public MultiFormattedCharSequenceWidget(int x, int y, FormattedCharSequence ... component) {
        this(x, y, MultiFormattedCharSequenceWidget.componentWidth(component), component);
    }

    public MultiFormattedCharSequenceWidget(int x, int y, int width, FormattedCharSequence ... component) {
        Objects.requireNonNull(font);
        super(x, y, width, 9 * component.length, (Component)Component.empty(), font);
        this.shadow = true;
        this.component = component;
    }

    public MultiFormattedCharSequenceWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    private static int componentWidth(FormattedCharSequence[] component) {
        int width = 0;
        for (FormattedCharSequence c : component) {
            if (font.width(c) <= width) continue;
            width = font.width(c);
        }
        return width;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int y = this.getY();
        for (FormattedCharSequence c : this.component) {
            guiGraphics.drawString(font, c, this.getX(), y, this.getColor(), this.shadow);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

