/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMinecraftUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.IBarWidget;

public interface IValueBarWidget
extends IBarWidget {
    public float getMaxValue();

    public float getValue();

    default public void setValue(float value) {
        if (Mth.abs((float)(value - this.getValue())) < 0.1f) {
            return;
        }
        this.setProgress(value / this.getMaxValue());
    }

    default public void setMaxValue(float maxValue) {
    }

    default public boolean shouldRenderText() {
        return true;
    }

    default public Font getFont() {
        return IUIMinecraftUtils.getFont();
    }

    default public String format(float value) {
        return new DecimalFormat("##").format(value);
    }

    default public String getText() {
        return this.format(this.getValue()) + "/" + this.format(this.getMaxValue());
    }

    default public void renderText(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.shouldRenderText()) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
        float centerY = (float)this.getY() + (float)this.getHeight() / 2.0f;
        int n = this.getHeight();
        Objects.requireNonNull(this.getFont());
        if (n < 9) {
            float f = this.getHeight();
            Objects.requireNonNull(this.getFont());
            float s = f / 9.0f;
            pose.translate(centerX, centerY, 0.0f);
            pose.scale(s, s, 1.0f);
        }
        IUIGuiUtils.drawCenteredString(guiGraphics, this.getFont(), this.getText(), 0.0f, 0.0f, -1, false);
        pose.popPose();
    }
}

