/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.w2s;

import java.util.UUID;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.hiedacamellia.immersiveui.client.gui.animate.AnimateUtils;
import org.hiedacamellia.immersiveui.client.gui.component.w2s.IW2SWidget;
import org.joml.Vector2f;

@OnlyIn(value=Dist.CLIENT)
public abstract class World2ScreenWidget
implements IW2SWidget {
    public float xO;
    public float x;
    public float yO;
    public float y;
    public float scale;
    public boolean selectable = false;
    protected boolean limitInScreen = false;
    protected boolean smoothPosition = false;
    private boolean computed = false;
    private boolean inScreen = false;
    protected boolean shouldRemove = false;
    protected float alpha = 0.0f;
    protected UUID uuid;

    protected World2ScreenWidget(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public void setScreenPos(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void calculateRenderScale(float distance) {
        this.scale = (float)AnimateUtils.Lerp.smooth(0.0, 1.0, 1.0f - Math.max(distance - 1024.0f, 0.0f) / 8.0f);
    }

    @Override
    public void resize() {
    }

    public void invoke() {
    }

    @Override
    public void updateAlpha() {
        if (this.shouldRemove) {
            this.alpha -= 0.05f;
        } else if (this.alpha < 1.0f) {
            this.alpha += 0.05f;
        }
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.alpha <= 0.0f;
    }

    @Override
    public boolean shouldRemove() {
        return this.shouldRemove;
    }

    @Override
    public void setRemoved() {
        this.shouldRemove = true;
    }

    public boolean collided(World2ScreenWidget onGrid) {
        return Vector2f.distanceSquared((float)this.x, (float)this.y, (float)onGrid.x, (float)onGrid.y) < 1024.0f;
    }

    public void moveIfOverlapped(World2ScreenWidget other) {
        float dx = this.x - other.x;
        float dy = this.y - other.y;
        float distance = Mth.sqrt((float)(dx * dx + dy * dy));
        if (distance < 32.0f) {
            float moveDistance = 32.0f - distance;
            float moveX = moveDistance / distance * dx;
            float moveY = moveDistance / distance * dy;
            this.x += moveX;
            this.y += moveY;
        }
    }

    @Override
    public void setComputed() {
        this.computed = true;
    }

    @Override
    public boolean isComputed() {
        return this.computed;
    }

    @Override
    public boolean limitInScreen() {
        return this.limitInScreen;
    }

    @Override
    public boolean shouldRender() {
        return this.inScreen && this.scale > 0.0f;
    }

    @Override
    public boolean shouldSmoothPosition() {
        return this.smoothPosition;
    }

    @Override
    public boolean shouldSkip() {
        return false;
    }

    @Override
    public void setInScreen(boolean inScreen) {
        this.inScreen = inScreen;
    }

    @Override
    public boolean isInScreen() {
        return this.inScreen;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getXO() {
        return this.xO;
    }

    @Override
    public float getYO() {
        return this.yO;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public void setXO(float xO) {
        this.xO = xO;
    }

    @Override
    public void setYO(float yO) {
        this.yO = yO;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }
}

