/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.graphic.util;

import org.joml.Vector4f;

public class IUIMathUtils {
    public static float smoothStep(float start, float end, float v) {
        v = Math.max(0.0f, Math.min(1.0f, (v - start) / (end - start)));
        return v * v * (3.0f - 2.0f * v);
    }

    public static double smoothStep(double start, double end, double v) {
        v = Math.max(0.0, Math.min(1.0, (v - start) / (end - start)));
        return v * v * (3.0 - 2.0 * v);
    }

    public static float smoothPulse(float time, float duration, float riseFraction, float fallFraction) {
        if (time < 0.0f || duration <= 0.0f) {
            return 0.0f;
        }
        float riseEnd = duration * riseFraction;
        float fallStart = duration * (1.0f - fallFraction);
        if (time < riseEnd) {
            return IUIMathUtils.smoothStep(0.0f, riseEnd, time);
        }
        if (time > fallStart) {
            return 1.0f - IUIMathUtils.smoothStep(fallStart, duration, time);
        }
        return 1.0f;
    }

    public static double smoothPulse(double time, double duration, double riseFraction, double fallFraction) {
        if (time < 0.0 || duration <= 0.0) {
            return 0.0;
        }
        double riseEnd = duration * riseFraction;
        double fallStart = duration * (1.0 - fallFraction);
        if (time < riseEnd) {
            return IUIMathUtils.smoothStep(0.0, riseEnd, time);
        }
        if (time > fallStart) {
            return 1.0 - IUIMathUtils.smoothStep(fallStart, duration, time);
        }
        return 1.0;
    }

    public static Vector4f int2RGBA(int color) {
        return new Vector4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public static Vector4f int2ARGB(int color) {
        return new Vector4f((float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }
}

