/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.graphic.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderProgram;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.hiedacamellia.immersiveui.ImmersiveUI;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMinecraftUtils;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveui")
public class IUIShaders {
    private static final ShaderProgram roundRect = new ShaderProgram(ImmersiveUI.rl("core/round_rect"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);
    private static final ShaderProgram borderRoundRect = new ShaderProgram(ImmersiveUI.rl("core/border_round_rect"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);
    private static final ShaderProgram positionTexShader = new ShaderProgram(ImmersiveUI.rl("core/position_tex"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);
    private static final ShaderProgram blurShader = new ShaderProgram(ImmersiveUI.rl("core/blur"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);
    private static final ShaderProgram ringShader = new ShaderProgram(ImmersiveUI.rl("core/ring"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);
    private static final ShaderProgram roundShader = new ShaderProgram(ImmersiveUI.rl("core/round"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);
    private static final ShaderProgram borderRect = new ShaderProgram(ImmersiveUI.rl("core/border_rect"), DefaultVertexFormat.POSITION_TEX_COLOR, ShaderDefines.EMPTY);

    public static CompiledShaderProgram getRoundRectShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(roundRect), "Round Rect Shader not loaded");
    }

    public static CompiledShaderProgram getBorderRoundRectShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(borderRoundRect), "Border Round Rect Shader not loaded");
    }

    public static CompiledShaderProgram getPositionTexShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(positionTexShader), "Position Tex Shader not loaded");
    }

    public static CompiledShaderProgram getBlurShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(blurShader), "Blur Shader not loaded");
    }

    public static CompiledShaderProgram getRingShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(ringShader), "Ring Shader not loaded");
    }

    public static CompiledShaderProgram getRoundShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(roundShader), "Round Shader not loaded");
    }

    public static CompiledShaderProgram getBorderRectShader() {
        return Objects.requireNonNull(IUIMinecraftUtils.getShaderProgram(borderRect), "Border Rect Shader not loaded");
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(roundRect);
        event.registerShader(borderRoundRect);
        event.registerShader(positionTexShader);
        event.registerShader(blurShader);
        event.registerShader(ringShader);
        event.registerShader(roundShader);
        event.registerShader(borderRect);
    }
}

