/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.hiedacamellia.immersiveui.ImmersiveUI;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMathUtils;
import org.hiedacamellia.immersiveui.client.gui.animate.LerpNumberAnimation;
import org.hiedacamellia.immersiveui.client.gui.component.w2s.IW2SWidget;
import org.hiedacamellia.immersiveui.client.gui.component.w2s.World2ScreenScreen;
import org.hiedacamellia.immersiveui.client.gui.component.w2s.World2ScreenWidget;
import org.hiedacamellia.immersiveui.util.holder.FloatHolder;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class World2ScreenWidgetLayer
implements LayeredDraw.Layer {
    public static final World2ScreenWidgetLayer INSTANCE = new World2ScreenWidgetLayer();
    public static final ResourceLocation LOCATION = ImmersiveUI.rl("world_screen_layer");
    public static final int FADE_BEGIN_DISTANCE = 1024;
    public static final int FADE_DISTANCE = 8;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final Map<UUID, IW2SWidget> objects = new Object2ObjectOpenHashMap();
    private final Map<UUID, IW2SWidget> onRemoving = new Object2ObjectOpenHashMap();
    private final Set<UUID> toRemove = new ObjectOpenHashSet();
    private final List<IW2SWidget> inRange = new ObjectArrayList();
    private final FloatHolder click = new FloatHolder(0.0f);
    private final LerpNumberAnimation animation = new LerpNumberAnimation(this.click, IUIMathUtils::smoothLerp, 0.0, 1.0, 0.5f);
    private IW2SWidget highlight;
    private IW2SWidget locked;
    public World2ScreenScreen activeScreen;
    public UUID screenUUID;
    private double scroll = 0.0;

    World2ScreenWidgetLayer() {
        this.reset();
    }

    public boolean hasScreen() {
        return this.activeScreen != null;
    }

    public void setActiveScreen(World2ScreenScreen activeScreen) {
        this.activeScreen = activeScreen;
        this.screenUUID = activeScreen.getId();
    }

    public void reset() {
        this.objects.clear();
        this.inRange.clear();
        this.highlight = null;
    }

    public void resize() {
        this.objects.values().forEach(IW2SWidget::resize);
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        boolean highlight1;
        IW2SWidget object;
        if (this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        float deltaTicks = deltaTracker.getGameTimeDeltaTicks();
        this.update(deltaTicks);
        Iterator<IW2SWidget> iterator = this.objects.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!object.isComputed() || !object.shouldRender()) continue;
            object.updateAlpha();
            highlight1 = this.locked != null ? object == this.locked : object == this.highlight;
            boolean shouldRemove = object.shouldRemove();
            if (!(!shouldRemove || highlight1 && this.animation.isRunning())) {
                if (object == this.locked) {
                    this.locked = null;
                }
                iterator.remove();
                continue;
            }
            float d0 = object.getX();
            float d1 = object.getY();
            if (object.shouldSmoothPosition()) {
                d0 = Mth.lerp((float)deltaTicks, (float)object.getXO(), (float)object.getX());
                d1 = Mth.lerp((float)deltaTicks, (float)object.getYO(), (float)object.getY());
            }
            object.setXO(d0);
            object.setYO(d1);
            if (highlight1) {
                object.render(guiGraphics, true, this.click.get().floatValue(), deltaTracker);
                continue;
            }
            object.render(guiGraphics, false, 0.0f, deltaTracker);
        }
        iterator = this.onRemoving.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            object.updateAlpha();
            if (object.shouldBeRemoved()) {
                iterator.remove();
                continue;
            }
            if (!object.isComputed() || !object.shouldRender()) continue;
            highlight1 = this.locked != null ? object == this.locked : object == this.highlight;
            float d0 = object.getX();
            float d1 = object.getY();
            if (object.shouldSmoothPosition()) {
                d0 = Mth.lerp((float)deltaTicks, (float)object.getXO(), (float)object.getX());
                d1 = Mth.lerp((float)deltaTicks, (float)object.getYO(), (float)object.getY());
            }
            object.setXO(d0);
            object.setYO(d1);
            if (highlight1) {
                object.render(guiGraphics, true, this.click.get().floatValue(), deltaTracker);
                continue;
            }
            object.render(guiGraphics, false, 0.0f, deltaTracker);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void update(float deltaTicks) {
        if (this.minecraft.level == null) {
            return;
        }
        if (!this.toRemove.isEmpty()) {
            this.toRemove.forEach(e -> {
                IW2SWidget widget = this.objects.get(e);
                if (widget == null) {
                    return;
                }
                widget.setRemoved();
                this.onRemoving.put((UUID)e, widget);
            });
            this.toRemove.clear();
        }
        GameRenderer gameRenderer = this.minecraft.gameRenderer;
        Camera camera = gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        double fov = gameRenderer.getFov(camera, deltaTicks, true);
        Matrix4f projectionMatrix = gameRenderer.getProjectionMatrix(fov);
        Matrix4f viewMatrix = new Matrix4f().rotation((Quaternionfc)camera.rotation().conjugate(new Quaternionf())).translate((float)(-cameraPos.x), (float)(-cameraPos.y), (float)(-cameraPos.z));
        Matrix4f mat = new Matrix4f().mul((Matrix4fc)projectionMatrix).mul((Matrix4fc)viewMatrix);
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        float half = (float)screenWidth / 2.0f;
        float left = half - 32.0f;
        float right = half + 32.0f;
        this.inRange.clear();
        Vector3f pos = new Vector3f();
        for (IW2SWidget object : this.objects.values()) {
            if (object.shouldSkip()) continue;
            object.setComputed();
            object.getWorldPos(pos);
            Vector4f cameraSpacePos = new Vector4f((Vector3fc)pos, 1.0f).mul((Matrix4fc)mat);
            if (cameraSpacePos.w < 0.0f) {
                cameraSpacePos.y = screenHeight;
                cameraSpacePos.x = -cameraSpacePos.x;
            }
            float x = (int)((cameraSpacePos.x() / cameraSpacePos.z() * 0.5f + 0.5f) * (float)screenWidth);
            float y = (int)((1.0f - (cameraSpacePos.y() / cameraSpacePos.z() * 0.5f + 0.5f)) * (float)screenHeight);
            if (object.limitInScreen()) {
                x = Mth.clamp((float)x, (float)16.0f, (float)(screenWidth - 16));
                y = Mth.clamp((float)y, (float)16.0f, (float)(screenHeight - 16));
            }
            object.setInScreen(x > 0.0f && y > 0.0f && x < (float)screenWidth && y < (float)screenHeight);
            object.setScreenPos(x, y);
            float distance = Vector3f.distanceSquared((float)pos.x, (float)pos.y, (float)pos.z, (float)((float)cameraPos.x), (float)((float)cameraPos.y), (float)((float)cameraPos.z));
            object.calculateRenderScale(distance);
            if (object.getScale() < 1.0f || this.locked != null || !(object.getX() > left) || !(object.getX() < right) || !object.isSelectable()) continue;
            this.inRange.add(object);
        }
        if (!this.animation.isRunning()) {
            this.highlight = !this.inRange.isEmpty() ? this.inRange.get((int)this.scroll % this.inRange.size()) : null;
        }
    }

    public void addWorldPositionObject(World2ScreenWidget widget) {
        this.addWorldPositionObject(widget.getId(), widget);
    }

    public void addWorldPositionObject(UUID uuid, World2ScreenWidget widget) {
        if (widget == null) {
            this.toRemove.add(uuid);
            return;
        }
        this.objects.put(uuid, widget);
    }

    public void addWorldPositionObjectForced(UUID uuid, World2ScreenWidget widget) {
        this.objects.put(uuid, widget);
    }

    public void remove(UUID other) {
        this.toRemove.add(other);
    }

    public IW2SWidget get(UUID uuid) {
        return this.objects.get(uuid);
    }

    public boolean scroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scroll = this.inRange.isEmpty() ? 0.0 : (this.scroll + mouseY) % (double)this.inRange.size();
        boolean consumed = false;
        for (IW2SWidget object : this.objects.values()) {
            if (!object.scroll(mouseX, mouseY, scrollX, scrollY)) continue;
            consumed = true;
        }
        return consumed;
    }

    public boolean click(int button) {
        if (this.minecraft.gameMode != null && this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return false;
        }
        boolean consumed = false;
        for (IW2SWidget object : this.objects.values()) {
            if (!object.click(button)) continue;
            consumed = true;
        }
        if (!consumed) {
            this.activeScreen = null;
            this.screenUUID = null;
        }
        return consumed;
    }

    public void lock(World2ScreenWidget locked) {
        this.locked = locked;
    }
}

