/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.layer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.hiedacamellia.immersiveui.ImmersiveUI;
import org.hiedacamellia.immersiveui.client.graphic.target.ScreenTempTarget;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGraphicUtils;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMinecraftUtils;
import org.hiedacamellia.immersiveui.client.util.MouseCaptureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ScreenWidgetLayer
implements LayeredDraw.Layer {
    public static final ScreenWidgetLayer INSTANCE = new ScreenWidgetLayer();
    public static final ResourceLocation LOCATION = ImmersiveUI.rl("screen_layer");
    @Nullable
    protected Screen screen;
    protected boolean enableOffset = true;
    protected float offsetFactor = 8.0f;
    protected double mouseX;
    protected double mouseY;
    protected boolean drawVirtualMouse = true;
    protected float virtualMouseInnerRadius = 3.0f;
    protected float virtualMouseOuterRadius = 7.0f;

    @Nullable
    public Screen getScreen() {
        return this.screen;
    }

    public void setScreen(@NotNull Screen screen) {
        this.screen = screen;
        this.screen.init(Minecraft.getInstance(), IUIMinecraftUtils.getGuiScaledWidth(), IUIMinecraftUtils.getGuiScaledHeight());
        this.mouseX = IUIMinecraftUtils.getGuiScaledCenterX();
        this.mouseY = IUIMinecraftUtils.getGuiScaledCenterY();
        MouseCaptureUtil.startMouseCapture();
    }

    public void removeScreen() {
        this.screen = null;
        MouseCaptureUtil.stopMouseCapture();
    }

    public boolean hasScreen() {
        return this.screen != null;
    }

    public void setEnableOffset(boolean enableOffset) {
        this.enableOffset = enableOffset;
    }

    public void setOffsetFactor(float offsetFactor) {
        this.offsetFactor = offsetFactor;
    }

    public void addPos(double mouseX, double mouseY) {
        this.mouseX = Mth.clamp((double)(this.mouseX + mouseX), (double)0.0, (double)IUIMinecraftUtils.getGuiScaledWidth());
        this.mouseY = Mth.clamp((double)(this.mouseY + mouseY), (double)0.0, (double)IUIMinecraftUtils.getGuiScaledHeight());
    }

    public boolean click(int button, int action) {
        if (this.screen != null) {
            if (action == 1) {
                return this.screen.mouseClicked(this.mouseX, this.mouseY, button);
            }
            if (action == 0) {
                return this.screen.mouseReleased(this.mouseX, this.mouseY, button);
            }
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.screen != null) {
            return this.screen.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (Minecraft.getInstance().gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            this.removeScreen();
        }
        if (this.screen != null) {
            int w = IUIMinecraftUtils.getGuiScaledWidth();
            int h = IUIMinecraftUtils.getGuiScaledHeight();
            double andResetCapturedDeltaX = MouseCaptureUtil.getAndResetCapturedDeltaX();
            double andResetCapturedDeltaY = MouseCaptureUtil.getAndResetCapturedDeltaY();
            this.addPos(andResetCapturedDeltaX, andResetCapturedDeltaY);
            double offsetX = this.enableOffset ? -andResetCapturedDeltaX / (double)this.offsetFactor : 0.0;
            double offsetY = this.enableOffset ? -andResetCapturedDeltaY / (double)this.offsetFactor : 0.0;
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            ScreenTempTarget.SCREEN_INSTANCE.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            ScreenTempTarget.SCREEN_INSTANCE.clear(Minecraft.ON_OSX);
            ScreenTempTarget.BLUR_INSTANCE.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            ScreenTempTarget.BLUR_INSTANCE.clear(Minecraft.ON_OSX);
            RenderTarget mainRenderTarget = IUIMinecraftUtils.getMainRenderTarget();
            mainRenderTarget.unbindWrite();
            ScreenTempTarget.BLUR_INSTANCE.bindWrite(true);
            ScreenTempTarget.BLUR_INSTANCE.use = true;
            ScreenTempTarget.SCREEN_INSTANCE.use = true;
            IUIGraphicUtils.blit(pose, mainRenderTarget.getColorTextureId(), 0.0f, 0.0f, (float)w, (float)h, 0.0f, 1.0f, 1.0f, 0.0f);
            this.screen.render(guiGraphics, (int)this.mouseX, (int)this.mouseY, deltaTracker.getGameTimeDeltaTicks());
            guiGraphics.flush();
            pose.popPose();
            ScreenTempTarget.SCREEN_INSTANCE.unbindWrite();
            ScreenTempTarget.BLUR_INSTANCE.use = false;
            ScreenTempTarget.SCREEN_INSTANCE.use = false;
            mainRenderTarget.bindWrite(true);
            pose.pushPose();
            RenderSystem.enableBlend();
            IUIGraphicUtils.blit(pose, ScreenTempTarget.BLUR_INSTANCE.getColorTextureId(), 0.0f, 0.0f, (float)w, (float)h, 0.0f, 1.0f, 1.0f, 0.0f);
            pose.popPose();
            pose.pushPose();
            IUIGraphicUtils.blit(pose, ScreenTempTarget.SCREEN_INSTANCE.getColorTextureId(), (float)offsetX, (float)offsetY, (float)(offsetX + (double)w), (float)(offsetY + (double)h), 0.0f, 1.0f, 1.0f, 0.0f);
            pose.popPose();
            if (this.drawVirtualMouse) {
                IUIGuiUtils.drawRing(guiGraphics, (float)this.mouseX, (float)this.mouseY, this.virtualMouseInnerRadius, this.virtualMouseOuterRadius, 0.0f, 360.0f, -1, 0.1f);
            }
        }
    }

    public void setDrawVirtualMouse(boolean drawVirtualMouse) {
        this.drawVirtualMouse = drawVirtualMouse;
    }

    public void setVirtualMouseRadius(float innerRadius, float outerRadius) {
        this.virtualMouseInnerRadius = innerRadius;
        this.virtualMouseOuterRadius = outerRadius;
    }
}

