/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMathUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.toast.IToastWidget;

public abstract class AbstractToastWidget
extends AbstractWidget
implements IToastWidget {
    protected boolean fadeIn = true;
    protected long startTime = 0L;
    protected long duration = 500L;

    @Override
    public long getAnimationStartTime() {
        return this.startTime;
    }

    @Override
    public void setAnimationStartTime(long time) {
        this.startTime = time;
    }

    @Override
    public long getAnimationDuration() {
        return this.duration;
    }

    @Override
    public void setAnimationDuration(long duration) {
        this.duration = duration;
    }

    public AbstractToastWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    protected float getAlpha() {
        float alpha = 1.0f;
        if (this.fadeIn) {
            alpha = IUIMathUtils.smoothPulse(this.getElapsedTime(), this.duration, 0.1f, 0.1f);
        }
        return alpha;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isAnimationEnd()) {
            return;
        }
        if (this.getMessage().getString().isEmpty()) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0, 0.0, 1000.0);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        this.renderToast(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        pose.popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

